/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanMutableFrame;

public class CanReply
extends AbstractMRReply
implements CanMutableFrame {
    int _header;
    boolean _isExtended = false;
    boolean _isRtr = false;

    public CanReply() {
        this._nDataChars = 8;
        super.setBinary(true);
        this._dataChars = new int[8];
    }

    public CanReply(int i) {
        this();
        this.setNumDataElements(i <= 8 ? i : 8);
    }

    public CanReply(int[] d) {
        this();
        this.setData(d);
        this.setNumDataElements(d.length <= 8 ? d.length : 8);
    }

    public CanReply(int[] d, int header) {
        this();
        this.setHeader(header);
        this.setData(d);
        this.setNumDataElements(d.length <= 8 ? d.length : 8);
    }

    public CanReply(@Nonnull CanReply m) {
        this();
        this._header = m.getHeader();
        this._isExtended = m.isExtended();
        this._isRtr = m.isRtr();
        super.setBinary(true);
        this.setData(m.getData());
        this.setNumDataElements(m.getNumDataElements());
    }

    public CanReply(@Nonnull CanMessage m) {
        this();
        this._header = m.getHeader();
        this._isExtended = m.isExtended();
        this._isRtr = m.isRtr();
        super.setBinary(true);
        this.setData(Arrays.copyOf(m.getData(), m.getNumDataElements()));
        this.setNumDataElements(m.getNumDataElements());
    }

    @Override
    public int hashCode() {
        return this._header;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality test done in CanFrame")
    public boolean equals(Object a) {
        return this.isEqual(a, this);
    }

    @Override
    protected int skipPrefix(int index) {
        return index;
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    @Override
    public final void setNumDataElements(int n) {
        this._nDataChars = n <= 8 ? n : 8;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    public int[] getData() {
        return this._dataChars;
    }

    @Override
    public int getHeader() {
        return this._header;
    }

    @Override
    public final void setHeader(int h) {
        this._header = h;
    }

    @Override
    public boolean isExtended() {
        return this._isExtended;
    }

    @Override
    public void setExtended(boolean b) {
        this._isExtended = b;
    }

    @Override
    public boolean isRtr() {
        return this._isRtr;
    }

    @Override
    public void setRtr(boolean b) {
        this._isRtr = b;
    }

    @Override
    public String toString() {
        return this.getToString();
    }

    @Override
    public String toMonitorString() {
        return this.monString();
    }
}

