/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.gridconnect.Bundle;
import jmri.jmrix.can.adapters.gridconnect.GcPortController;
import jmri.jmrix.can.adapters.gridconnect.GcTrafficController;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcSerialDriverAdapter
extends GcPortController {
    protected AbstractSerialPortController.FlowControl flowControl = AbstractSerialPortController.FlowControl.NONE;
    InputStream serialStream = null;
    private InputStream bufferedStream = null;
    private static final Logger log = LoggerFactory.getLogger(GcSerialDriverAdapter.class);

    public GcSerialDriverAdapter() {
        super(new CanSystemConnectionMemo());
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions()));
        this.manufacturerName = "MERG";
        this.allowConnectionRecovery = true;
    }

    public GcSerialDriverAdapter(String prefix) {
        super(new CanSystemConnectionMemo(prefix));
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions()));
        this.manufacturerName = "MERG";
        this.allowConnectionRecovery = true;
    }

    public GcSerialDriverAdapter(String prefix, AbstractSerialPortController.FlowControl flow) {
        super(new CanSystemConnectionMemo(prefix));
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions()));
        this.manufacturerName = "MERG";
        this.allowConnectionRecovery = true;
        this.flowControl = flow;
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect CAN to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting CAN to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.localSetFlowControl();
        this.serialStream = this.currentSerialPort.getInputStream();
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    protected void localSetFlowControl() {
        this.setFlowControl(this.currentSerialPort, this.flowControl);
    }

    @Override
    public void configure() {
        GcTrafficController tc = this.makeGcTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        log.debug("Connecting port");
        tc.connectPort(this);
        this.getSystemConnectionMemo().setProtocol(this.getOptionState(this.option1Name));
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    protected void resetupConnection() {
        if (!this.getSystemConnectionMemo().getTrafficController().status()) {
            this.getSystemConnectionMemo().getTrafficController().connectPort(this);
            ConnectionStatus.instance().setConnectionState(this.getUserName(), this.getCurrentPortName(), this.getSystemConnectionMemo().getTrafficController().status() && this.status() ? "Connected" : "Not Connected");
        }
    }

    @Override
    protected void closeConnection() {
        log.info("Closing connection {}.", (Object)this.getCurrentPortName());
        try {
            if (this.serialStream != null) {
                this.serialStream.close();
            }
            this.serialStream = null;
            if (this.bufferedStream != null) {
                this.bufferedStream.close();
            }
            this.bufferedStream = null;
        }
        catch (IOException e) {
            log.error("unable to close {}", (Object)this.currentSerialPort);
        }
        if (this.currentSerialPort != null) {
            this.currentSerialPort.closePort();
        }
        this.currentSerialPort = null;
    }

    protected GcTrafficController makeGcTrafficController() {
        return new GcTrafficController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        GcSerialDriverAdapter gcSerialDriverAdapter = this;
        synchronized (gcSerialDriverAdapter) {
            if (this.bufferedStream == null) {
                this.bufferedStream = new AsyncBufferInputStream(this.serialStream, this.currentSerialPort.toString());
            }
            return new DataInputStream(this.bufferedStream);
        }
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200"), Bundle.getMessage("Baud230400"), Bundle.getMessage("Baud250000"), Bundle.getMessage("Baud333333"), Bundle.getMessage("Baud460800")};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600, 115200, 230400, 250000, 333333, 460800};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }

    private static class AsyncBufferInputStream
    extends FilterInputStream {
        private boolean active;
        private final String portName;
        private static final int MAX_IO_ERRORS_TO_ABORT = 10;
        private final BlockingQueue<BufferEntry> readAhead = new LinkedBlockingQueue<BufferEntry>();
        BufferEntry head = null;
        int headOfs = 0;
        int errorCount = 0;

        AsyncBufferInputStream(InputStream inputStream, String portName) {
            super(inputStream);
            this.portName = portName;
            this.active = true;
            Thread rt = ThreadingUtil.newThread(this::readThreadBody);
            rt.setName("GcSerialPort InputBufferThread " + portName);
            rt.setDaemon(true);
            rt.setPriority(10);
            rt.start();
        }

        private BufferEntry tryRead(int maxLen) {
            BufferEntry tail = new BufferEntry();
            try {
                int len = Math.max(1, Math.min(maxLen, this.in.available()));
                tail.data = new byte[len];
                tail.len = this.in.read(tail.data, 0, len);
                this.errorCount = 0;
            }
            catch (IOException e) {
                tail.e = e;
                if (++this.errorCount > 10) {
                    log.error("Closing read thread due to too many IO errors", (Throwable)e);
                    return null;
                }
                log.debug("Error reading serial port {}", (Object)this.portName, (Object)e);
            }
            return tail;
        }

        private void readThreadBody() {
            block0: while (this.active) {
                BufferEntry tail = this.tryRead(1);
                if (tail == null) {
                    return;
                }
                if (tail.len <= 0 && tail.e == null) continue;
                this.readAhead.add(tail);
                while ((tail = this.tryRead(128)) != null) {
                    if (tail.len <= 0 && tail.e == null) continue block0;
                    this.readAhead.add(tail);
                }
                return;
            }
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized int read(byte[] bytes, int skip, int len) throws IOException {
            int cp;
            if (skip != 0) {
                throw new UnsupportedOperationException();
            }
            if (this.head == null || this.headOfs >= this.head.len) {
                try {
                    this.head = this.readAhead.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.head.e != null) {
                    throw this.head.e;
                }
                this.headOfs = 0;
                if (this.head.len < 0) {
                    return -1;
                }
            }
            if ((cp = this.head.len - this.headOfs) > len) {
                cp = len;
            }
            System.arraycopy(this.head.data, this.headOfs, bytes, 0, cp);
            this.headOfs += cp;
            return cp;
        }

        @Override
        public void close() throws IOException {
            this.active = false;
            super.close();
        }

        private static class BufferEntry {
            byte[] data;
            int len = 0;
            IOException e = null;

            private BufferEntry() {
            }
        }
    }
}

