/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.adapters.gridconnect.GridConnectMessage;
import jmri.jmrix.can.adapters.gridconnect.GridConnectReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcTrafficController
extends TrafficController {
    public static final int NORMAL = 0;
    public static final int BOOTMODE = 1;
    private int gcState;
    private static final Logger log = LoggerFactory.getLogger(GcTrafficController.class);

    public GcTrafficController() {
        this.setSynchronizeRx(false);
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((CanListener)client).message((CanMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        if (r != null) {
            ((CanListener)client).reply((CanReply)r);
        } else {
            log.error("Found unexpected null message", (Throwable)new Exception("traceback"));
        }
    }

    public int getgcState() {
        return this.gcState;
    }

    public void setgcState(int state) {
        this.gcState = state;
        log.debug("Setting gcState {}", (Object)state);
    }

    public boolean isBootMode() {
        return this.gcState == 1;
    }

    @Override
    public void sendCanMessage(CanMessage m, CanListener reply) {
        log.debug("GcTrafficController sendCanMessage() {}", (Object)m.toString());
        this.sendMessage(m, reply);
    }

    @Override
    public void sendCanReply(CanReply r, CanListener reply) {
        log.debug("TrafficController sendCanReply() {}", (Object)r.toString());
        this.notifyReply(r, reply);
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements();
    }

    @Override
    protected AbstractMRMessage newMessage() {
        log.debug("New GridConnectMessage created");
        return new GridConnectMessage();
    }

    @Override
    public CanReply decodeFromHardware(AbstractMRReply m) {
        GridConnectReply gc = new GridConnectReply();
        log.debug("Decoding from hardware");
        try {
            gc = (GridConnectReply)m;
        }
        catch (ClassCastException cce) {
            log.error("{} cannot cast to a GridConnectReply", (Object)m);
        }
        CanReply ret = gc.createReply();
        return ret;
    }

    @Override
    public AbstractMRMessage encodeForHardware(CanMessage m) {
        return new GridConnectMessage(m);
    }

    @Override
    protected AbstractMRReply newReply() {
        log.debug("New GridConnectReply created");
        return new GridConnectReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply r) {
        return this.endNormalReply(r);
    }

    boolean endNormalReply(AbstractMRReply r) {
        int num = r.getNumDataElements() - 1;
        if (r.getElement(num) == 59) {
            log.debug("End of normal message detected");
            return true;
        }
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        for (int i = 0; i < msg.maxSize(); ++i) {
            byte char1 = this.readByteProtected(istream);
            if (i == 0) {
                while (char1 != 58) {
                    char1 = this.readByteProtected(istream);
                }
            }
            if (this.flushReceiveChars) {
                log.warn("timeout flushes receive buffer: {}", (Object)msg.toString());
                msg.flush();
                i = 0;
                this.flushReceiveChars = false;
            }
            if (this.canReceive()) {
                msg.setElement(i, char1);
                if (!this.endOfMessage(msg)) continue;
                break;
            }
            --i;
            log.error("unsolicited character received: {}", (Object)Integer.toHexString(char1));
        }
    }
}

