/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.can.CanMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridConnectMessage
extends AbstractMRMessage {
    private static final Logger log = LoggerFactory.getLogger(GridConnectMessage.class);

    public GridConnectMessage() {
        this._nDataChars = 28;
        this._dataChars = new int[this._nDataChars];
        this.setElement(0, 58);
    }

    public GridConnectMessage(CanMessage m) {
        this();
        this.addCanMessage(m);
    }

    private void addCanMessage(CanMessage m) {
        this.setExtended(m.isExtended());
        this.setHeader(m.getHeader());
        this.setRtr(m.isRtr());
        for (int i = 0; i < m.getNumDataElements(); ++i) {
            this.setByte(m.getElement(i), i);
        }
        int offset = this.isExtended() ? 11 : 6;
        this.setElement(offset + m.getNumDataElements() * 2, 59);
        this.setNumDataElements(offset + 1 + m.getNumDataElements() * 2);
        log.debug("encoded as {}", (Object)this.toString());
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    public void setNumDataElements(int n) {
        this._nDataChars = n <= 28 ? n : 28;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = v;
    }

    public void setData(int[] d) {
        int len = d.length <= 24 ? d.length : 24;
        System.arraycopy(d, 0, this._dataChars, 0, len);
    }

    public void setExtended(boolean extended) {
        if (extended) {
            this.setElement(1, 88);
        } else {
            this.setElement(1, 83);
        }
    }

    public boolean isExtended() {
        return this.getElement(1) == 88;
    }

    public void setHeader(int header) {
        if (this.isExtended()) {
            this.setHexDigit(header >> 28 & 0xF, 2);
            this.setHexDigit(header >> 24 & 0xF, 3);
            this.setHexDigit(header >> 20 & 0xF, 4);
            this.setHexDigit(header >> 16 & 0xF, 5);
            this.setHexDigit(header >> 12 & 0xF, 6);
            this.setHexDigit(header >> 8 & 0xF, 7);
            this.setHexDigit(header >> 4 & 0xF, 8);
            this.setHexDigit(header & 0xF, 9);
        } else {
            this.setHexDigit(header >> 8 & 0xF, 2);
            this.setHexDigit(header >> 4 & 0xF, 3);
            this.setHexDigit(header & 0xF, 4);
        }
    }

    public void setRtr(boolean rtr) {
        int offset = this.isExtended() ? 10 : 5;
        this.setElement(offset, rtr ? 82 : 78);
    }

    public void setByte(int val, int n) {
        if (n >= 0 && n <= 7) {
            int index = n * 2 + (this.isExtended() ? 11 : 6);
            this.setHexDigit(val / 16 & 0xF, index++);
            this.setHexDigit(val & 0xF, index);
        }
    }

    protected void setHexDigit(int val, int n) {
        this._dataChars[n] = val >= 0 && val <= 15 ? (val < 10 ? val + 48 : val - 10 + 65) : 48;
    }
}

