/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridConnectReply
extends AbstractMRReply {
    static final int MAXLEN = 27;
    int _RTRoffset = -1;
    private static final Logger log = LoggerFactory.getLogger(GridConnectReply.class);

    public GridConnectReply() {
        this._nDataChars = 0;
        this._dataChars = new int[27];
    }

    public GridConnectReply(String s) {
        this._nDataChars = s.length();
        for (int i = 0; i < s.length(); ++i) {
            this._dataChars[i] = s.charAt(i);
        }
    }

    public CanReply createReply() {
        CanReply ret = new CanReply();
        log.debug("createReply converts from {}", (Object)this);
        if (!this.basicFormatCheck()) {
            ret.setHeader(0);
            ret.setNumDataElements(0);
            return ret;
        }
        if (this.isExtended()) {
            ret.setExtended(true);
        }
        ret.setHeader(this.getHeader());
        if (this.isRtr()) {
            ret.setRtr(true);
        }
        for (int i = 0; i < this.getNumBytes(); ++i) {
            ret.setElement(i, this.getByte(i));
        }
        ret.setNumDataElements(this.getNumBytes());
        log.debug("createReply converted to {}", (Object)ret);
        return ret;
    }

    protected boolean basicFormatCheck() {
        return this.getElement(1) == 88 || this.getElement(1) == 83;
    }

    @Override
    protected int skipPrefix(int index) {
        while (this._dataChars[index] == 58) {
            ++index;
        }
        return index;
    }

    @Override
    public int getNumDataElements() {
        return this._nDataChars;
    }

    public void setNumDataElements(int n) {
        this._nDataChars = n <= 27 ? n : 27;
    }

    @Override
    public int getElement(int n) {
        return this._dataChars[n];
    }

    @Override
    public void setElement(int n, int v) {
        if (n < 27) {
            this._dataChars[n] = v;
            this._nDataChars = Math.max(this._nDataChars, n + 1);
        }
    }

    public boolean isExtended() {
        return this.getElement(1) == 88;
    }

    public boolean isRtr() {
        return this.getElement(this._RTRoffset) == 82;
    }

    @Override
    public int maxSize() {
        return 27;
    }

    public void setData(int[] d) {
        int len = d.length <= 27 ? d.length : 27;
        System.arraycopy(d, 0, this._dataChars, 0, len);
    }

    public int getHeader() {
        int val = 0;
        for (int i = 2; i <= 10; ++i) {
            this._RTRoffset = i;
            if (this._dataChars[i] == 78 || this._dataChars[i] == 82) break;
            val = val * 16 + this.getHexDigit(i);
        }
        return val;
    }

    public int getNumBytes() {
        return (this._nDataChars - (this._RTRoffset + 1)) / 2;
    }

    public int getByte(int b) {
        if (b >= 0 && b <= 7) {
            int index = b * 2 + this._RTRoffset + 1;
            int hi = this.getHexDigit(index++);
            int lo = this.getHexDigit(index);
            if (hi < 16 && lo < 16) {
                return hi * 16 + lo;
            }
        }
        return 0;
    }

    private int getHexDigit(int index) {
        int b = this._dataChars[index];
        b = b >= 48 && b <= 57 ? (b -= 48) : (b >= 65 && b <= 70 ? b - 65 + 10 : (b >= 97 && b <= 102 ? b - 97 + 10 : 0));
        return (byte)b;
    }
}

