/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.can2usbino.serialdriver;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.adapters.gridconnect.GcSerialDriverAdapter;
import jmri.jmrix.can.adapters.gridconnect.GcTrafficController;
import jmri.jmrix.can.adapters.gridconnect.can2usbino.GridConnectDoubledMessage;
import jmri.jmrix.can.adapters.gridconnect.can2usbino.serialdriver.Bundle;

public class SerialDriverAdapter
extends GcSerialDriverAdapter {
    public SerialDriverAdapter() {
        this.mBaudRate = Bundle.getMessage("Baud230400");
    }

    @Override
    public String openPort(String portName, String appName) {
        String retval = super.openPort(portName, appName);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.XONXOFF);
        return retval;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200"), Bundle.getMessage("Baud230400"), Bundle.getMessage("Baud250000"), Bundle.getMessage("Baud288000"), Bundle.getMessage("Baud333333"), Bundle.getMessage("Baud460800")};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{57600, 115200, 230400, 250000, 288000, 333333, 460800};
    }

    @Override
    public int defaultBaudIndex() {
        return 2;
    }

    @Override
    protected GcTrafficController makeGcTrafficController() {
        return new GcTrafficController(){

            @Override
            public AbstractMRMessage encodeForHardware(CanMessage m) {
                return new GridConnectDoubledMessage(m);
            }
        };
    }
}

