/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.canrs;

import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.adapters.gridconnect.GridConnectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergMessage
extends GridConnectMessage {
    private static final Logger log = LoggerFactory.getLogger(MergMessage.class);

    public MergMessage() {
    }

    public MergMessage(CanMessage m) {
        this();
        this.setExtended(m.isExtended());
        this.setHeader(m.getHeader());
        this.setRtr(m.isRtr());
        for (int i = 0; i < m.getNumDataElements(); ++i) {
            this.setByte(m.getElement(i), i);
        }
        int offset = this.isExtended() ? 11 : 7;
        this.setElement(offset + m.getNumDataElements() * 2, 59);
        this.setNumDataElements(offset + 1 + m.getNumDataElements() * 2);
        log.debug("encoded as {}", (Object)this);
    }

    @Override
    public void setHeader(int header) {
        if (this.isExtended()) {
            int munged = header << 3 & 0xFFE00000 | 0x80000 | header & 0x3FFFF;
            log.debug("Extended header is {}, munged header is {}", (Object)header, (Object)munged);
            super.setHeader(munged);
        } else {
            int munged = header << 5;
            log.debug("Standard header is {}, munged header is {}", (Object)header, (Object)munged);
            this.setHexDigit(munged >> 12 & 0xF, 2);
            this.setHexDigit(munged >> 8 & 0xF, 3);
            this.setHexDigit(munged >> 4 & 0xF, 4);
            this.setHexDigit(0, 5);
        }
    }

    @Override
    public void setRtr(boolean rtr) {
        int offset = this.isExtended() ? 10 : 6;
        this.setElement(offset, rtr ? 82 : 78);
    }

    @Override
    public void setByte(int val, int n) {
        if (n >= 0 && n <= 7) {
            int index = n * 2 + (this.isExtended() ? 11 : 7);
            if (val < 0 || val > 255) {
                log.error("Byte value {} out of range 0-255 for MergMessage data payload", (Object)val, (Object)new IllegalArgumentException());
                val = 0;
            }
            this.setHexDigit(val / 16 & 0xF, index++);
            this.setHexDigit(val & 0xF, index);
            return;
        }
        log.error("Byte Index {} out of range 0-7 for MergMessage data payload", (Object)n, (Object)new IllegalArgumentException());
    }
}

