/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.net;

import jmri.jmrix.AbstractNetworkPortController;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.gridconnect.GcTrafficController;
import jmri.jmrix.can.adapters.gridconnect.canrs.MergTrafficController;
import jmri.jmrix.can.adapters.gridconnect.net.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDriverAdapter
extends AbstractNetworkPortController {
    private static final Logger log = LoggerFactory.getLogger(NetworkDriverAdapter.class);

    public NetworkDriverAdapter() {
        super(new CanSystemConnectionMemo());
        this.option1Name = "Gateway";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionGateway"), new String[]{"Pass All", "Filtering"}));
        this.option2Name = "Protocol";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions(), false));
        super.setManufacturer("OpenLCB");
        this.allowConnectionRecovery = true;
    }

    @Override
    public void configure() {
        GcTrafficController tc;
        switch (this.getOptionState(this.option2Name)) {
            case "MERG CBUS": 
            case "SPROG CBUS": {
                tc = new MergTrafficController();
                tc.setCanId(this.getOptionState("CANID"));
                break;
            }
            default: {
                tc = new GcTrafficController();
            }
        }
        this.getSystemConnectionMemo().setTrafficController(tc);
        log.debug("Connecting port");
        tc.connectPort(this);
        this.getSystemConnectionMemo().setProtocol(this.getOptionState(this.option2Name));
        this.getSystemConnectionMemo().configureManagers();
        if (this.socketConn != null) {
            log.info("{} Connection via {} complete with {}", new Object[]{this.getSystemConnectionMemo().getUserName(), this.getOptionState(this.option2Name), this.socketConn.getInetAddress()});
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public CanSystemConnectionMemo getSystemConnectionMemo() {
        return (CanSystemConnectionMemo)super.getSystemConnectionMemo();
    }

    @Override
    protected void resetupConnection() {
        log.info("reconnected to Network after lost connection");
        if (this.opened) {
            this.getSystemConnectionMemo().getTrafficController().connectPort(this);
        }
    }
}

