/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.gridconnect.sproggen5.serialdriver;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.gridconnect.GcSerialDriverAdapter;
import jmri.jmrix.can.adapters.gridconnect.canrs.MergTrafficController;
import jmri.jmrix.can.adapters.gridconnect.sproggen5.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanisbSerialDriverAdapter
extends GcSerialDriverAdapter {
    private static final Logger log = LoggerFactory.getLogger(CanisbSerialDriverAdapter.class);

    public CanisbSerialDriverAdapter() {
        super("S");
        this.option2Name = "CANID";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("JMRICANID"), new String[]{"127", "126", "125", "124", "123", "122", "121", "120"}));
    }

    @Override
    public void configure() {
        MergTrafficController tc = new MergTrafficController();
        try {
            tc.setCanId(Integer.parseInt(this.getOptionState(this.option2Name)));
        }
        catch (Exception e) {
            log.error("Cannot parse CAN ID - check your preference settings", (Throwable)e);
            log.error("Now using default CAN ID");
        }
        this.getSystemConnectionMemo().setTrafficController(tc);
        log.debug("Connecting port");
        tc.connectPort(this);
        this.getSystemConnectionMemo().setProtocol(this.getOptionState(this.option1Name));
        this.getSystemConnectionMemo().setSubProtocol(ConfigurationManager.SubProtocol.CBUS);
        this.getSystemConnectionMemo().setProgModeSwitch(ConfigurationManager.ProgModeSwitch.NONE);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{Bundle.getMessage("Baud460800")};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{460800};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

