/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.lawicell;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reply
extends AbstractMRReply {
    private static final Logger log = LoggerFactory.getLogger(Reply.class);

    public Reply() {
    }

    public Reply(String s) {
        this._nDataChars = s.length();
        for (int i = 0; i < s.length(); ++i) {
            this._dataChars[i] = s.charAt(i);
        }
    }

    public CanReply createReply() {
        if (this._dataChars[0] != 116 && this._dataChars[0] != 84 && this._dataChars[0] != 114 && this._dataChars[0] != 82) {
            log.debug("non-frame reply skipped: {}", (Object)this);
            return null;
        }
        CanReply ret = new CanReply();
        ret.setExtended(this.isExtended());
        ret.setRtr(this.isRtrSet());
        ret.setHeader(this.getHeader());
        for (int i = 0; i < this.getNumBytes(); ++i) {
            ret.setElement(i, this.getByte(i));
        }
        ret.setNumDataElements(this.getNumBytes());
        return ret;
    }

    @Override
    protected int skipPrefix(int index) {
        while (this._dataChars[index] == 58) {
            ++index;
        }
        return index;
    }

    public void setData(int[] d) {
        int len = d.length <= 24 ? d.length : 24;
        System.arraycopy(d, 0, this._dataChars, 0, len);
    }

    public boolean isExtended() {
        return this._dataChars[0] == 84 || this._dataChars[0] == 82;
    }

    public boolean isRtrSet() {
        return this._dataChars[0] == 114 || this._dataChars[0] == 82;
    }

    public int getHeader() {
        if (this.isExtended()) {
            int val = 0;
            for (int i = 1; i <= 8; ++i) {
                val = val * 16 + this.getHexDigit(i);
            }
            return val;
        }
        return this.getHexDigit(1) * 256 + this.getHexDigit(2) * 16 + this.getHexDigit(3);
    }

    public int getNumBytes() {
        if (this.isExtended()) {
            return this._dataChars[9] - 48;
        }
        return this._dataChars[4] - 48;
    }

    public int getByte(int b) {
        if (b >= 0 && b <= 7) {
            int index = b * 2 + (this.isExtended() ? 10 : 5);
            int hi = this.getHexDigit(index++);
            int lo = this.getHexDigit(index);
            if (hi < 16 && lo < 16) {
                return hi * 16 + lo;
            }
        }
        return 0;
    }

    private int getHexDigit(int index) {
        int b = this._dataChars[index];
        b = b >= 48 && b <= 57 ? (b -= 48) : (b >= 65 && b <= 70 ? b - 65 + 10 : (b >= 97 && b <= 102 ? b - 97 + 10 : 0));
        return (byte)b;
    }
}

