/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.lawicell;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.lawicell.Bundle;
import jmri.jmrix.can.adapters.lawicell.LawicellTrafficController;
import jmri.jmrix.can.adapters.lawicell.PortController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends PortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud57600"), Bundle.getMessage("Baud115200"), Bundle.getMessage("Baud230400"), Bundle.getMessage("Baud250000"), Bundle.getMessage("Baud333333"), Bundle.getMessage("Baud460800"), Bundle.getMessage("Baud500000")};
    protected int[] validSpeedValues = new int[]{57600, 115200, 230400, 250000, 333333, 460800, 500000};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new CanSystemConnectionMemo());
        this.option1Name = "Protocol";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), ConfigurationManager.getSystemOptions()));
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect CAN Lawicell to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting CAN Lawicell to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        LawicellTrafficController tc = new LawicellTrafficController();
        this.getSystemConnectionMemo().setTrafficController(tc);
        log.debug("Connecting port");
        tc.connectPort(this);
        log.debug("send version request");
        CanMessage m = new CanMessage(new int[]{86, 13, 83, 52, 13, 79, 13}, tc.getCanid());
        m.setTranslated(true);
        tc.sendCanMessage(m, null);
        this.getSystemConnectionMemo().setProtocol(this.getOptionState(this.option1Name));
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

