/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.loopback;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopbackTrafficController
extends TrafficController {
    protected CanSystemConnectionMemo adaptermemo;
    private static final Logger log = LoggerFactory.getLogger(LoopbackTrafficController.class);

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((CanListener)client).message((CanMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((CanListener)client).reply((CanReply)r);
    }

    public boolean isBootMode() {
        return false;
    }

    @Override
    public void sendCanMessage(CanMessage m, CanListener reply) {
        log.debug("TrafficController sendCanMessage() {}", (Object)m.toString());
        this.notifyMessage(m, reply);
    }

    @Override
    public void sendCanReply(CanReply r, CanListener reply) {
        log.debug("TrafficController sendCanReply() {}", (Object)r.toString());
        this.notifyReply(r, reply);
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return m.getNumDataElements();
    }

    @Override
    protected AbstractMRMessage newMessage() {
        log.debug("New CanMessage created");
        return new CanMessage(this.getCanid());
    }

    @Override
    public CanReply decodeFromHardware(AbstractMRReply m) {
        log.error("decodeFromHardware unexpected");
        return null;
    }

    @Override
    public AbstractMRMessage encodeForHardware(CanMessage m) {
        log.error("encodeForHardware unexpected");
        return null;
    }

    @Override
    protected AbstractMRReply newReply() {
        log.debug("New CanReply created");
        return new CanReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply r) {
        log.error("endOfMessage unexpected");
        return true;
    }
}

