/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.adapters.loopback.configurexml;

import jmri.jmrix.PortAdapter;
import jmri.jmrix.can.adapters.loopback.ConnectionConfig;
import jmri.jmrix.can.adapters.loopback.Port;
import jmri.jmrix.can.adapters.loopback.configurexml.Bundle;
import jmri.jmrix.configurexml.AbstractSerialConnectionConfigXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionConfigXml
extends AbstractSerialConnectionConfigXml {
    private static final Logger log = LoggerFactory.getLogger(ConnectionConfigXml.class);

    @Override
    public Element store(Object o) {
        this.adapter = ((ConnectionConfig)o).getAdapter();
        Element e = new Element("connection");
        if (this.adapter.getCurrentPortName() != null) {
            e.setAttribute("port", this.adapter.getCurrentPortName());
        } else {
            e.setAttribute("port", Bundle.getMessage("noneSelected"));
        }
        if (this.adapter.getManufacturer() != null) {
            e.setAttribute("manufacturer", this.adapter.getManufacturer());
        }
        if (this.adapter.getSystemConnectionMemo() != null) {
            e.setAttribute("userName", this.adapter.getSystemConnectionMemo().getUserName());
            e.setAttribute("systemPrefix", this.adapter.getSystemConnectionMemo().getSystemPrefix());
        }
        if (this.adapter.getDisabled()) {
            e.setAttribute("disabled", "yes");
        } else {
            e.setAttribute("disabled", "no");
        }
        this.saveOptions(e, this.adapter);
        this.setOutputInterval(this.adapter, e);
        e.setAttribute("class", this.getClass().getName());
        this.extendElement(e);
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String yesno;
        boolean result = true;
        this.getInstance();
        if (this.adapter.getSystemConnectionMemo() != null) {
            if (shared.getAttribute("userName") != null) {
                this.adapter.getSystemConnectionMemo().setUserName(shared.getAttribute("userName").getValue());
            }
            if (shared.getAttribute("systemPrefix") != null) {
                this.adapter.getSystemConnectionMemo().setSystemPrefix(shared.getAttribute("systemPrefix").getValue());
            }
        }
        if (shared.getAttribute("option1") != null) {
            String option1Setting = shared.getAttribute("option1").getValue();
            this.adapter.configureOption1(option1Setting);
        }
        if (shared.getAttribute("manufacturer") != null) {
            String mfg = shared.getAttribute("manufacturer").getValue();
            this.adapter.setManufacturer(mfg);
        }
        if (shared.getAttribute("port") != null) {
            String portName = shared.getAttribute("port").getValue();
            this.adapter.setPort(portName);
        }
        if (shared.getAttribute("disabled") != null && (yesno = shared.getAttribute("disabled").getValue()) != null && !yesno.isEmpty()) {
            if (yesno.equals("no")) {
                this.adapter.setDisabled(false);
            } else if (yesno.equals("yes")) {
                this.adapter.setDisabled(true);
            }
        }
        this.loadOptions(shared.getChild("options"), perNode.getChild("options"), this.adapter);
        this.register();
        if (this.adapter.getDisabled()) {
            this.unpackElement(shared, perNode);
            return result;
        }
        this.adapter.configure();
        if (perNode.getAttribute("turnoutInterval") != null) {
            this.adapter.getSystemConnectionMemo().setOutputInterval(Integer.parseInt(perNode.getAttribute("turnoutInterval").getValue()));
        }
        return result;
    }

    @Override
    protected void getInstance() {
        this.adapter = new Port();
    }

    @Override
    protected void getInstance(Object object) {
        this.adapter = ((ConnectionConfig)object).getAdapter();
    }

    @Override
    protected void register() {
        this.register(new ConnectionConfig(this.adapter));
        log.info("CAN Simulator Started");
    }

    @Override
    protected void loadOptions(Element shared, Element perNode, PortAdapter adapter) {
        super.loadOptions(shared, perNode, adapter);
        jmri.jmrix.openlcb.configurexml.ConnectionConfigXml.maybeLoadOlcbProfileSettings(shared.getParentElement(), perNode.getParentElement(), adapter);
    }

    @Override
    protected void extendElement(Element e) {
        jmri.jmrix.openlcb.configurexml.ConnectionConfigXml.maybeSaveOlcbProfileSettings(e, this.adapter);
    }
}

