/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusAddress {
    static final String SINGLE_ADDRESS_PATTERN = "((\\+|-)?\\d++)|([Xx](\\p{XDigit}\\p{XDigit}){1,8})|((\\+|-)?([Nn])?(\\d++)[Ee](\\d++))";
    private final Matcher hCode = Pattern.compile("^((\\+|-)?\\d++)|([Xx](\\p{XDigit}\\p{XDigit}){1,8})|((\\+|-)?([Nn])?(\\d++)[Ee](\\d++))$").matcher("");
    private String aString = null;
    protected int[] aFrame = null;
    private boolean match = false;
    static final int NODEFACTOR = 100000;
    private static final String[] invalidChars = new String[]{"G", "H", "I", "J", "K", "L", "M", "S", "T", "U", "V", "W", "Y", "Z", "?", ":", "++", "--", ",", "*", "NN", "XX"};
    private static final Logger log = LoggerFactory.getLogger(CbusAddress.class);

    public CbusAddress(String s) {
        this.aString = s;
        this.match = this.hCode.reset(this.aString).matches();
        if (this.match) {
            if (this.hCode.group(1) != null) {
                this.aFrame = new int[5];
                int n = Integer.parseInt(this.aString.substring(1, this.aString.length()));
                int node = n / 100000;
                int event = n % 100000;
                this.aFrame[4] = event & 0xFF;
                this.aFrame[3] = event >> 8 & 0xFF;
                this.aFrame[2] = node & 0xFF;
                this.aFrame[1] = node >> 8 & 0xFF;
                switch (this.aString.substring(0, 1)) {
                    case "-": {
                        if (node > 0) {
                            this.aFrame[0] = 145;
                            break;
                        }
                        this.aFrame[0] = 153;
                        break;
                    }
                    default: {
                        if (node > 0) {
                            this.aFrame[0] = 144;
                            break;
                        }
                        this.aFrame[0] = 152;
                        break;
                    }
                }
            } else if (this.hCode.group(3) != null) {
                String l = this.hCode.group(3);
                int len = (l.length() - 1) / 2;
                this.aFrame = new int[len];
                for (int i = 0; i < len; ++i) {
                    String two = l.substring(1 + 2 * i, 1 + 2 * i + 2);
                    this.aFrame[i] = Integer.parseInt(two, 16);
                }
            } else if (this.hCode.group(5) != null) {
                this.aFrame = new int[5];
                int node = Integer.parseInt(this.hCode.group(8));
                int event = Integer.parseInt(this.hCode.group(9));
                this.aFrame[4] = event & 0xFF;
                this.aFrame[3] = event >> 8 & 0xFF;
                this.aFrame[2] = node & 0xFF;
                this.aFrame[1] = node >> 8 & 0xFF;
                this.aFrame[0] = this.hCode.group(6) != null && this.hCode.group(6).equals("+") ? 144 : (this.hCode.group(6) != null && this.hCode.group(6).equals("-") ? 145 : 144);
            }
        }
    }

    public boolean equals(Object r) {
        if (r == null) {
            return false;
        }
        if (!r.getClass().equals(this.getClass())) {
            return false;
        }
        CbusAddress opp = (CbusAddress)r;
        if (opp.aFrame.length != this.aFrame.length) {
            return false;
        }
        for (int i = 0; i < this.aFrame.length; ++i) {
            if (this.aFrame[i] == opp.aFrame[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.aFrame.length; ++i) {
            ret += this.aFrame[i];
        }
        return ret;
    }

    public CanMessage makeMessage(int header) {
        return new CanMessage(this.aFrame, header);
    }

    public boolean check() {
        return this.hCode.reset(this.aString).matches();
    }

    public boolean match(AbstractMessage r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        if (CbusMessage.isShort(r)) {
            if (this.aFrame[0] != r.getElement(0)) {
                return false;
            }
            for (int i = 3; i < this.aFrame.length; ++i) {
                if (this.aFrame[i] == r.getElement(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.aFrame.length; ++i) {
                if (this.aFrame[i] == r.getElement(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matchRequest(CanReply r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        if (CbusMessage.isShort(r)) {
            if (154 != r.getElement(0)) {
                return false;
            }
            for (int i = 3; i < this.aFrame.length; ++i) {
                if (this.aFrame[i] == r.getElement(i)) continue;
                return false;
            }
        } else {
            if (146 != r.getElement(0)) {
                return false;
            }
            for (int i = 1; i < this.aFrame.length; ++i) {
                if (this.aFrame[i] == r.getElement(i)) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public CbusAddress[] split() {
        if (this.aString.endsWith(";")) {
            return new CbusAddress[0];
        }
        String[] pStrings = this.aString.split(";");
        CbusAddress[] retval = new CbusAddress[pStrings.length];
        for (int i = 0; i < pStrings.length; ++i) {
            if (pStrings[i].isEmpty()) {
                return new CbusAddress[0];
            }
            if (!this.hCode.reset(pStrings[i]).matches()) {
                return new CbusAddress[0];
            }
            retval[i] = new CbusAddress(pStrings[i]);
        }
        return retval;
    }

    @Nonnull
    public static String getIncrement(@Nonnull String testAddr) throws JmriException {
        String newString;
        log.debug("testing address {}", (Object)testAddr);
        CbusAddress.validateSysName(testAddr);
        CbusAddress a = new CbusAddress(testAddr);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 2: {
                int lasta = StringUtil.getLastIntFromString(v[0].toString());
                int lastb = StringUtil.getLastIntFromString(v[1].toString());
                StringBuilder sb = new StringBuilder();
                sb.append(StringUtil.replaceLast(v[0].toString(), String.valueOf(lasta), String.valueOf(lasta + 1)));
                sb.append(";");
                sb.append(StringUtil.replaceLast(v[1].toString(), String.valueOf(lastb), String.valueOf(lastb + 1)));
                newString = sb.toString();
                break;
            }
            case 1: {
                int last = StringUtil.getLastIntFromString(v[0].toString());
                newString = StringUtil.replaceLast(v[0].toString(), String.valueOf(last), String.valueOf(last + 1));
                break;
            }
            default: {
                throw new JmriException("Unable to increment " + testAddr);
            }
        }
        try {
            return CbusAddress.validateSysName(newString);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException("Unable to increment " + testAddr + " " + e.getMessage());
        }
    }

    public static String validateSysName(String address) throws IllegalArgumentException {
        if (address == null || ((String)address).isEmpty()) {
            throw new IllegalArgumentException("No Address passed ");
        }
        for (String s : invalidChars) {
            if (!((String)address).contains(s)) continue;
            throw new NamedBean.BadSystemNameException(Locale.getDefault(), "InvalidSystemNameCharacter", address, s);
        }
        if (((String)address).endsWith(";")) {
            throw new IllegalArgumentException("Should not end with ; " + (String)address);
        }
        String[] addressArray = ((String)address).split(";");
        switch (addressArray.length) {
            case 1: {
                address = CbusAddress.checkPartOfName(addressArray[0], "+");
                break;
            }
            case 2: {
                address = CbusAddress.checkPartOfName(addressArray[0], "+") + ";" + CbusAddress.checkPartOfName(addressArray[1], "-");
                break;
            }
            default: {
                log.debug("validateSysName switch 1 found > 2 events");
                throw new IllegalArgumentException("Unable to convert Address: " + (String)address);
            }
        }
        CbusAddress a = new CbusAddress((String)address);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 1: {
                if (((String)address).startsWith("+") || ((String)address).startsWith("-")) break;
                try {
                    int unsigned = Integer.parseInt((String)address);
                    if (unsigned > 100000) {
                        break;
                    }
                }
                catch (NumberFormatException ex) {
                    log.debug("Unable to convert {} into Cbus format +nn", address);
                }
                throw new IllegalArgumentException("can't make 2nd event from address " + (String)address);
            }
            case 2: {
                break;
            }
            default: {
                log.debug("validateSysName switch 2 found > 2 events");
                throw new IllegalArgumentException("Wrong number of events in address: " + (String)address);
            }
        }
        return address;
    }

    private static String checkPartOfName(String testpart, String plusOrMinus) {
        int unsigned = 0;
        Object part = testpart;
        try {
            unsigned = Integer.parseInt((String)part);
            log.debug("part {} is integer {}", part, (Object)unsigned);
            if (((String)part).charAt(0) != '+' && ((String)part).charAt(0) != '-' && unsigned > 0 && unsigned < 65536) {
                part = plusOrMinus + (String)part;
            }
            if (unsigned > 65535 && unsigned < 100000) {
                throw new IllegalArgumentException("On Too big for an event, too low for node + event : " + (String)part);
            }
            if (unsigned < -65535 && unsigned > -100000) {
                throw new IllegalArgumentException("Off Too big for an event, too low for node + event : " + (String)part);
            }
        }
        catch (NumberFormatException ex) {
            log.debug("Unable to convert {} into Cbus format +nn", part);
        }
        if (unsigned == 0) {
            try {
                if (((String)part).toUpperCase().charAt(0) != 'X') {
                    log.debug("not an int or hex {}", part);
                    int lasta = StringUtil.getLastIntFromString((String)part);
                    log.debug("last string {}", (Object)lasta);
                    if (lasta > 65535) {
                        throw new IllegalArgumentException("Event Too Large in address: " + (String)part);
                    }
                    int firsta = StringUtil.getFirstIntFromString((String)part);
                    log.debug("first string {}", (Object)firsta);
                    if (firsta > 65535) {
                        throw new IllegalArgumentException("Node Too Large in address: " + (String)part);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new IllegalArgumentException("Address Too Short? : " + (String)part);
            }
        }
        return part;
    }

    public boolean checkSplit() {
        switch (this.split().length) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    int[] elements() {
        return Arrays.copyOf(this.aFrame, this.aFrame.length);
    }

    public String toString() {
        return this.aString;
    }

    public String toCanonicalString() {
        String retval = "x";
        for (int i = 0; i < this.aFrame.length; ++i) {
            retval = StringUtil.appendTwoHexFromInt(this.aFrame[i], retval);
        }
        return retval;
    }
}

