/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import javax.annotation.CheckForNull;
import jmri.CommandStation;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusCommandStation
implements CommandStation {
    private final TrafficController tc;
    private final CanSystemConnectionMemo adapterMemo;
    private static final Logger log = LoggerFactory.getLogger(CbusCommandStation.class);

    public CbusCommandStation(CanSystemConnectionMemo memo) {
        this.tc = memo.getTrafficController();
        this.adapterMemo = memo;
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        if (repeats < 1) {
            repeats = 1;
            log.warn("Ops Mode Accessory Packet 'Send count' of < 1 is illegal and is forced to 1.");
        }
        if (repeats > 8) {
            repeats = 8;
            log.warn("Ops Mode Accessory Packet 'Send count' reduced to 8.");
        }
        CanMessage m = new CanMessage(2 + packet.length, this.tc.getCanid());
        m.setElement(0, 128 + ((packet.length - 3 & 3) << 5));
        m.setElement(1, repeats);
        for (int j = 0; j < packet.length; ++j) {
            m.setElement(j + 2, packet[j] & 0xFF);
        }
        this.tc.sendCanMessage(m, null);
        return true;
    }

    protected void releaseSession(int handle) {
        CanMessage msg = new CanMessage(2, this.tc.getCanid());
        msg.setOpCode(33);
        msg.setElement(1, handle);
        log.debug("Release session handle {}", (Object)handle);
        this.tc.sendCanMessage(msg, null);
    }

    protected void sendKeepAlive(int handle) {
        CanMessage msg = new CanMessage(2, this.tc.getCanid());
        msg.setOpCode(35);
        msg.setElement(1, handle);
        log.debug("keep alive handle: {}", (Object)handle);
        this.tc.sendCanMessage(msg, null);
    }

    protected void setSpeedDir(int handle, int speed_dir) {
        CanMessage msg = new CanMessage(3, this.tc.getCanid());
        msg.setOpCode(71);
        msg.setElement(1, handle);
        msg.setElement(2, speed_dir);
        log.debug("setSpeedDir session handle {} speedDir {}", (Object)handle, (Object)speed_dir);
        this.tc.sendCanMessage(msg, null);
    }

    protected void setFunctions(int group, int handle, int functions) {
        log.debug("Set function group {} Fns {} for session handle {}", new Object[]{group, functions, handle});
        CanMessage msg = new CanMessage(4, this.tc.getCanid());
        msg.setOpCode(96);
        msg.setElement(1, handle);
        msg.setElement(2, group);
        msg.setElement(3, functions);
        this.tc.sendCanMessage(msg, null);
    }

    protected void setSpeedSteps(int handle, int mode) {
        log.debug("Set speed step mode {} for session handle {}", (Object)mode, (Object)handle);
        CanMessage msg = new CanMessage(3, this.tc.getCanid());
        msg.setOpCode(68);
        msg.setElement(1, handle);
        msg.setElement(2, mode);
        this.tc.sendCanMessage(msg, null);
    }

    @CheckForNull
    protected CbusNode getMasterCommandStation() {
        CbusNodeTableDataModel nodeModel = this.adapterMemo.get(CbusNodeTableDataModel.class);
        if (nodeModel != null && nodeModel.getCsByNum(0) != null) {
            return nodeModel.getCsByNum(0);
        }
        return null;
    }

    protected boolean isStealAvailable() {
        CbusNode mCs = this.getMasterCommandStation();
        if (mCs != null) {
            log.debug("found master command station");
            if (mCs.getNodeNvManager().getNV(2) > -1) {
                log.debug("nv 2 has a value");
                return (mCs.getNodeNvManager().getNV(2) >> 1 & 1) != 0;
            }
        }
        return true;
    }

    protected boolean isShareAvailable() {
        CbusNode mCs = this.getMasterCommandStation();
        if (mCs != null && mCs.getNodeNvManager().getNV(2) > -1) {
            return (mCs.getNodeNvManager().getNV(2) >> 2 & 1) != 0;
        }
        return true;
    }

    @Override
    public String getUserName() {
        return this.adapterMemo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        return this.adapterMemo.getSystemPrefix();
    }
}

