/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CabSignalManager;
import jmri.ClockControl;
import jmri.CommandStation;
import jmri.ConsistManager;
import jmri.Disposable;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.adapters.loopback.LoopbackTrafficController;
import jmri.jmrix.can.cbus.CbusCabSignalManager;
import jmri.jmrix.can.cbus.CbusClockControl;
import jmri.jmrix.can.cbus.CbusCommandStation;
import jmri.jmrix.can.cbus.CbusConsistManager;
import jmri.jmrix.can.cbus.CbusDccProgrammer;
import jmri.jmrix.can.cbus.CbusDccProgrammerManager;
import jmri.jmrix.can.cbus.CbusLightManager;
import jmri.jmrix.can.cbus.CbusPowerManager;
import jmri.jmrix.can.cbus.CbusPredefinedMeters;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusReporterManager;
import jmri.jmrix.can.cbus.CbusSensorManager;
import jmri.jmrix.can.cbus.CbusThrottleManager;
import jmri.jmrix.can.cbus.CbusTurnoutManager;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.simulator.CbusSimulator;
import jmri.jmrix.can.cbus.swing.CbusComponentFactory;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorDataModel;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.AbstractMeterManager;

public class CbusConfigurationManager
extends ConfigurationManager
implements Disposable {
    private final ComponentFactory cf;
    private static final List<Class<?>> DEFAULT_CLASSES = List.of(CbusPreferences.class, PowerManager.class, SensorManager.class, CommandStation.class, TurnoutManager.class, ThrottleManager.class, CbusPredefinedMeters.class, ReporterManager.class, LightManager.class, CabSignalManager.class, ClockControl.class);
    private CbusDccProgrammerManager programmerManager;
    protected CbusConsistManager consistManager = null;

    public CbusConfigurationManager(@Nonnull CanSystemConnectionMemo memo) {
        super(memo);
        this.storeToMemoAndInstance(this, CbusConfigurationManager.class);
        this.cf = new CbusComponentFactory(this.adapterMemo);
        InstanceManager.store(this.cf, ComponentFactory.class);
    }

    @Override
    public void configureManagers() {
        for (Class<?> listClass : DEFAULT_CLASSES) {
            this.provide(listClass);
        }
        CbusDccProgrammerManager pm = this.getProgrammerManager();
        if (pm != null) {
            if (pm.isAddressedModeHardwareAvailable()) {
                this.storeToMemoAndInstance(pm, AddressedProgrammerManager.class);
            }
            if (pm.isGlobalProgrammerHardwareAvailable()) {
                this.storeToMemoAndInstance(pm, GlobalProgrammerManager.class);
            }
        }
        if (this.getConsistManager() != null) {
            this.storeToMemoAndInstance(this.getConsistManager(), ConsistManager.class);
        }
        if (this.adapterMemo.getTrafficController() instanceof LoopbackTrafficController) {
            this.adapterMemo.get(CbusSimulator.class);
        }
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.adapterMemo.getDisabled()) {
            return false;
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            return this.getProgrammerManager().isAddressedModePossible();
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            return this.getProgrammerManager().isGlobalProgrammerAvailable();
        }
        if (type.equals(ConsistManager.class)) {
            return true;
        }
        if (type.equals(CbusSimulator.class)) {
            return true;
        }
        if (type.equals(CbusSlotMonitorDataModel.class)) {
            return true;
        }
        return DEFAULT_CLASSES.contains(type);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (T.equals(AddressedProgrammerManager.class) && this.getProgrammerManager().isAddressedModePossible()) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(GlobalProgrammerManager.class) && this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(ConsistManager.class)) {
            return (T)this.getConsistManager();
        }
        if (T.equals(CbusSimulator.class)) {
            return this.provide(T);
        }
        if (T.equals(CbusSlotMonitorDataModel.class)) {
            return this.provide(T);
        }
        if (DEFAULT_CLASSES.contains(T)) {
            return this.provide(T);
        }
        return null;
    }

    private CbusDccProgrammerManager getProgrammerManager() {
        if (this.programmerManager == null && !this.adapterMemo.getDisabled()) {
            this.programmerManager = new CbusDccProgrammerManager((Programmer)new CbusDccProgrammer(this.adapterMemo), this.adapterMemo);
        }
        return this.programmerManager;
    }

    private ConsistManager getConsistManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.consistManager == null) {
            this.consistManager = new CbusConsistManager((CommandStation)this.get(CommandStation.class));
            if (this.adapterMemo.getProgModeSwitch() == ConfigurationManager.ProgModeSwitch.EITHER) {
                if (this.getProgrammerManager().isAddressedModePossible()) {
                    this.consistManager.setEnabled(true);
                } else {
                    this.consistManager.setEnabled(false);
                }
            } else {
                this.consistManager.setEnabled(true);
            }
        }
        return this.consistManager;
    }

    public <T> T provide(@Nonnull Class<?> T) {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        Object existing = this.adapterMemo.getFromMap(T);
        if (existing != null) {
            return existing;
        }
        if (T.equals(CbusNodeTableDataModel.class)) {
            this.storeToMemoAndInstance(new CbusNodeTableDataModel(this.adapterMemo, 10), CbusNodeTableDataModel.class);
        } else if (T.equals(CbusEventTableDataModel.class)) {
            this.storeToMemoAndInstance(new CbusEventTableDataModel(this.adapterMemo, 10), CbusEventTableDataModel.class);
        } else if (T.equals(CbusPreferences.class)) {
            this.storeToMemoAndInstance(new CbusPreferences(), CbusPreferences.class);
        } else if (T.equals(PowerManager.class)) {
            this.storeToMemoAndInstance(new CbusPowerManager(this.adapterMemo), PowerManager.class);
        } else if (T.equals(CommandStation.class)) {
            this.storeToMemoAndInstance(new CbusCommandStation(this.adapterMemo), CommandStation.class);
        } else if (T.equals(ThrottleManager.class)) {
            this.storeToMemoAndInstance(new CbusThrottleManager(this.adapterMemo), ThrottleManager.class);
        } else if (T.equals(CabSignalManager.class)) {
            this.storeToMemoAndInstanceDefault(new CbusCabSignalManager(this.adapterMemo), CabSignalManager.class);
        } else if (T.equals(ClockControl.class)) {
            this.storeToMemoAndInstanceDefault(new CbusClockControl(this.adapterMemo), ClockControl.class);
        } else if (T.equals(SensorManager.class)) {
            this.adapterMemo.store(new CbusSensorManager(this.adapterMemo), SensorManager.class);
            InstanceManager.setSensorManager((SensorManager)this.adapterMemo.getFromMap(T));
        } else if (T.equals(TurnoutManager.class)) {
            this.adapterMemo.store(new CbusTurnoutManager(this.adapterMemo), TurnoutManager.class);
            InstanceManager.setTurnoutManager((TurnoutManager)this.adapterMemo.getFromMap(T));
        } else if (T.equals(ReporterManager.class)) {
            this.adapterMemo.store(new CbusReporterManager(this.adapterMemo), ReporterManager.class);
            InstanceManager.setReporterManager((ReporterManager)this.adapterMemo.getFromMap(T));
        } else if (T.equals(LightManager.class)) {
            this.adapterMemo.store(new CbusLightManager(this.adapterMemo), LightManager.class);
            InstanceManager.setLightManager((LightManager)this.adapterMemo.getFromMap(T));
        } else if (T.equals(CbusPredefinedMeters.class)) {
            InstanceManager.setMeterManager(new AbstractMeterManager(this.adapterMemo));
            this.storeToMemoAndInstance(new CbusPredefinedMeters(this.adapterMemo), CbusPredefinedMeters.class);
        } else if (T.equals(CbusSimulator.class)) {
            this.storeToMemoAndInstance(new CbusSimulator(this.adapterMemo), CbusSimulator.class);
        } else if (T.equals(CbusSlotMonitorDataModel.class)) {
            this.storeToMemoAndInstance(new CbusSlotMonitorDataModel(this.adapterMemo), CbusSlotMonitorDataModel.class);
        }
        return this.adapterMemo.getFromMap(T);
    }

    private <T> void storeToMemoAndInstance(@Nonnull T item, @Nonnull Class<T> type) {
        this.adapterMemo.store(item, type);
        InstanceManager.store(item, type);
    }

    private <T> void storeToMemoAndInstanceDefault(@Nonnull T item, @Nonnull Class<T> type) {
        this.adapterMemo.store(item, type);
        InstanceManager.setDefault(type, item);
    }

    public <T> void disposeOf(@Nonnull T item, @Nonnull Class<T> type) {
        InstanceManager.deregister(item, type);
        this.adapterMemo.deregister(item, type);
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this.cf, ComponentFactory.class);
        if (this.consistManager != null) {
            InstanceManager.deregister(this.consistManager, ConsistManager.class);
        }
        if (this.programmerManager != null) {
            this.programmerManager.dispose();
        }
        InstanceManager.deregister(this, CbusConfigurationManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.can.CanActionListBundle");
    }
}

