/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusDccProgrammer;
import jmri.jmrix.can.cbus.CbusMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDccOpsModeProgrammer
extends CbusDccProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(CbusDccOpsModeProgrammer.class);

    public CbusDccOpsModeProgrammer(int pAddress, boolean pLongAddr, TrafficController tc) {
        super(tc);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("ops mode write CV={} val={}", (Object)CV, (Object)val);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.tc.sendCanMessage(CbusMessage.getOpsModeWriteCV(this.mAddress, this.mLongAddr, CV, val, this.tc.getCanid()), this);
        this.notifyProgListenerEnd(this._val, 0);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        log.error("readCV {} not available for MERG CBUS, a query to track would return all locos", (Object)CVname);
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.error("confirmCV {} not available for MERG CBUS, a query to track would return all locos", (Object)CV);
        throw new ProgrammerException();
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>(1);
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public synchronized void reply(CanReply m) {
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    void cleanup() {
    }
}

