/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.cbus.CbusFilterType;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;

public class CbusEventDataElements {
    private int _dat1;
    private int _dat2;
    private int _dat3;
    private int _numElements = 0;

    public CanMessage getCanMessage(int canId, int nn, int en, @Nonnull EvState state) {
        CanMessage m = new CanMessage(canId);
        CbusMessage.setPri(m, 11);
        m.setElement(1, nn >> 8);
        m.setElement(2, nn & 0xFF);
        m.setElement(3, en >> 8);
        m.setElement(4, en & 0xFF);
        switch (state) {
            case ON: 
            case OFF: {
                this.setCanMessageData(m);
                return this.finishEvent(m, nn > 0, state);
            }
        }
        return this.finishRequest(m, nn > 0);
    }

    private void setCanMessageData(CanMessage m) {
        m.setNumDataElements(5 + this._numElements);
        switch (this._numElements) {
            case 1: {
                m.setElement(5, this._dat1);
                break;
            }
            case 2: {
                m.setElement(5, this._dat1);
                m.setElement(6, this._dat2);
                break;
            }
            case 3: {
                m.setElement(5, this._dat1);
                m.setElement(6, this._dat2);
                m.setElement(7, this._dat3);
                break;
            }
        }
    }

    private CanMessage finishEvent(CanMessage m, boolean isLong, EvState state) {
        int opc;
        switch (this._numElements) {
            case 1: {
                opc = isLong ? 176 : 184;
                break;
            }
            case 2: {
                opc = isLong ? 208 : 216;
                break;
            }
            case 3: {
                opc = isLong ? 240 : 248;
                break;
            }
            default: {
                int n = opc = isLong ? 144 : 152;
            }
        }
        if (state == EvState.OFF) {
            ++opc;
        }
        m.setElement(0, opc);
        return m;
    }

    private CanMessage finishRequest(CanMessage m, boolean isLong) {
        m.setNumDataElements(5);
        if (isLong) {
            m.setElement(0, 146);
        } else {
            m.setElement(0, 154);
        }
        return m;
    }

    public void setNumElements(int elements) {
        if (elements < 0 || elements > 3) {
            throw new IllegalArgumentException(elements + " Event Data Elements Invalid");
        }
        this._numElements = elements;
    }

    public int getNumElements() {
        return this._numElements;
    }

    public void setData(int index, int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Data Value " + value + " Invalid");
        }
        switch (index) {
            case 1: {
                this._dat1 = value;
                break;
            }
            case 2: {
                this._dat2 = value;
                break;
            }
            case 3: {
                this._dat3 = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Data Index " + index + " Invalid");
            }
        }
    }

    public int getData(int index) {
        if (this.getNumElements() < index) {
            return -1;
        }
        switch (index) {
            case 1: {
                return this._dat1;
            }
            case 2: {
                return this._dat2;
            }
            case 3: {
                return this._dat3;
            }
        }
        throw new IllegalArgumentException("Data Index " + index + " Invalid");
    }

    public static int getNumEventDataElements(AbstractMessage m) {
        if (CbusFilterType.allFilters(m.getElement(0)).contains((Object)CbusFilterType.CFED1)) {
            return 1;
        }
        if (CbusFilterType.allFilters(m.getElement(0)).contains((Object)CbusFilterType.CFED2)) {
            return 2;
        }
        if (CbusFilterType.allFilters(m.getElement(0)).contains((Object)CbusFilterType.CFED3)) {
            return 3;
        }
        return 0;
    }

    public void setDataFromFrame(AbstractMessage m) {
        this.setNumElements(CbusEventDataElements.getNumEventDataElements(m));
        for (int i = 0; i < CbusEventDataElements.getNumEventDataElements(m); ++i) {
            this.setData(i + 1, m.getElement(i + 5));
        }
    }

    public static final EvState getEvState(AbstractMessage m) {
        EvState state = EvState.OFF;
        if (CbusOpCodes.isOnEvent(CbusMessage.getOpcode(m))) {
            state = EvState.ON;
        }
        if (CbusOpCodes.isEventRequest(CbusMessage.getOpcode(m))) {
            state = EvState.REQUEST;
        }
        return state;
    }

    public static String getJmriString(int nn, int en) {
        StringBuilder jmriAddress = new StringBuilder(13);
        jmriAddress.append("+");
        if (nn > 0) {
            jmriAddress.append("N");
            jmriAddress.append(nn);
            jmriAddress.append("E");
        }
        jmriAddress.append(en);
        return jmriAddress.toString();
    }

    public static enum EvState {
        ON,
        OFF,
        UNKNOWN,
        REQUEST,
        TOGGLE;

    }
}

