/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.awt.Color;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusMessage;

public class CbusEventHighlighter {
    private boolean _nnEnabled;
    private boolean _evEnabled;
    private int _nn;
    private int _ev;
    private int _type;
    private int _dir;
    private Color _color;

    public boolean highlight(AbstractMessage m) {
        if (m instanceof CanMessage) {
            return !this.doNotHighlight(m) && (this._dir == 3 || this._dir == 2);
        }
        if (m instanceof CanReply) {
            return !this.doNotHighlight(m) && (this._dir == 3 || this._dir == 1);
        }
        return false;
    }

    private boolean doNotHighlight(AbstractMessage m) {
        return !CbusMessage.isEvent(m) || this._nnEnabled && CbusMessage.getNodeNumber(m) != this._nn || this._evEnabled && CbusMessage.getEvent(m) != this._ev || this._type != 2 && this._type != CbusMessage.getEventType(m);
    }

    public void setNnEnable(boolean b) {
        this._nnEnabled = b;
    }

    public boolean getNnEnable() {
        return this._nnEnabled;
    }

    public void setEvEnable(boolean b) {
        this._evEnabled = b;
    }

    public boolean getEvEnable() {
        return this._evEnabled;
    }

    public void setNn(int n) {
        this._nn = n;
    }

    public int getNn() {
        return this._nn;
    }

    public void setEv(int n) {
        this._ev = n;
    }

    public int getEv() {
        return this._ev;
    }

    public void setType(int n) {
        this._type = n;
    }

    public int getType() {
        return this._type;
    }

    public void setDir(int n) {
        this._dir = n;
    }

    public int getDir() {
        return this._dir;
    }

    public void setColor(Color c) {
        this._color = c;
    }

    public Color getColor() {
        return this._color;
    }
}

