/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.ProgrammingMode;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanFrame;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanMutableFrame;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusOpCodes;

public class CbusMessage {
    public static CanReply opcRangeToStl(CanReply original) {
        CanReply msg = new CanReply(original);
        int opc = CbusMessage.getOpcode(msg);
        switch (opc) {
            case 147: {
                msg.setElement(0, 144);
                break;
            }
            case 148: {
                msg.setElement(0, 145);
                break;
            }
            case 157: {
                msg.setElement(0, 152);
                break;
            }
            case 158: {
                msg.setElement(0, 153);
                break;
            }
        }
        return msg;
    }

    public static int getOpcode(AbstractMessage am) {
        return am.getElement(0);
    }

    public static int getDataLength(AbstractMessage am) {
        return am.getElement(0) >> 5;
    }

    public static int getNodeNumber(AbstractMessage am) {
        if (CbusMessage.isEvent(am) && !CbusMessage.isShort(am)) {
            return am.getElement(1) * 256 + am.getElement(2);
        }
        return 0;
    }

    public static int getEvent(AbstractMessage m) {
        if (CbusMessage.isEvent(m)) {
            return m.getElement(3) * 256 + m.getElement(4);
        }
        return -1;
    }

    public static int getEventType(AbstractMessage am) {
        if (CbusOpCodes.isOnEvent(am.getElement(0))) {
            return 0;
        }
        return 1;
    }

    public static boolean isEvent(AbstractMessage am) {
        if (am instanceof CanFrame && ((CanFrame)((Object)am)).extendedOrRtr()) {
            return false;
        }
        return CbusOpCodes.isEvent(am.getElement(0));
    }

    public static boolean isShort(AbstractMessage am) {
        return CbusOpCodes.isShortEvent(am.getElement(0));
    }

    public static void setId(AbstractMessage am, int id) throws IllegalArgumentException {
        int update;
        CanMutableFrame m;
        if (am instanceof CanMutableFrame) {
            m = (CanMutableFrame)((Object)am);
            update = m.getHeader();
            if (m.isExtended()) {
                throw new IllegalArgumentException("No CAN ID Concept on Extended CBUS CAN Frame.");
            }
            if ((id & 0xFFFFFF80) != 0) {
                throw new IllegalArgumentException("invalid standard ID value: " + id);
            }
        } else {
            throw new IllegalArgumentException(am + " is Not a CanMutableFrame");
        }
        m.setHeader(update & 0xFFFFFF80 | id);
    }

    public static void setPri(AbstractMessage am, int pri) throws IllegalArgumentException {
        CanMutableFrame m;
        if (am instanceof CanMutableFrame) {
            m = (CanMutableFrame)((Object)am);
            if ((pri & 0xFFFFFFF0) != 0) {
                throw new IllegalArgumentException("Invalid CBUS Priority value: " + pri);
            }
            if (m.isExtended()) {
                throw new IllegalArgumentException("Extended CBUS CAN Frames do not have a priority concept.");
            }
        } else {
            throw new IllegalArgumentException(am + " is Not a CanMutableFrame");
        }
        m.setHeader(m.getHeader() & 0xFFFFF87F | pri << 7);
    }

    public static String toAddress(AbstractMessage m) {
        switch (m.getElement(0)) {
            case 144: {
                return "+n" + (m.getElement(1) * 256 + m.getElement(2)) + "e" + (m.getElement(3) * 256 + m.getElement(4));
            }
            case 145: {
                return "-n" + (m.getElement(1) * 256 + m.getElement(2)) + "e" + (m.getElement(3) * 256 + m.getElement(4));
            }
            case 152: {
                return "+" + (m.getElement(3) * 256 + m.getElement(4));
            }
            case 153: {
                return "-" + (m.getElement(3) * 256 + m.getElement(4));
            }
        }
        String tmp = m.toString().replaceAll("\\s*\\[[^\\]]*\\]\\s*", "");
        return "X" + tmp.replaceAll(" ", "");
    }

    public static boolean isRequestTrackOff(CanMessage m) {
        return m.getOpCode() == 8;
    }

    public static boolean isRequestTrackOn(CanMessage m) {
        return m.getOpCode() == 9;
    }

    public static int getId(AbstractMessage f) throws IllegalArgumentException {
        if (f instanceof CanFrame) {
            CanFrame cfMsg = (CanFrame)((Object)f);
            if (cfMsg.isExtended()) {
                return cfMsg.getHeader() & 0x1FFFFF;
            }
            return cfMsg.getHeader() & 0x7F;
        }
        throw new IllegalArgumentException(f + " is Not a CanFrame");
    }

    public static int getPri(AbstractMessage r) throws IllegalArgumentException {
        if (r instanceof CanFrame) {
            CanFrame cfMsg = (CanFrame)((Object)r);
            if (cfMsg.isExtended()) {
                return cfMsg.getHeader() >> 25 & 0xF;
            }
            return cfMsg.getHeader() >> 7 & 0xF;
        }
        throw new IllegalArgumentException(r + " is Not a CanFrame");
    }

    public static boolean isTrackOff(CanReply m) {
        return m.getOpCode() == 4;
    }

    public static boolean isTrackOn(CanReply m) {
        return m.getOpCode() == 5;
    }

    public static boolean isArst(CanReply m) {
        return m.getOpCode() == 7;
    }

    public static CanMessage getReadCV(int cv, ProgrammingMode mode, int header) {
        CanMessage m = new CanMessage(5, header);
        m.setElement(0, 132);
        m.setElement(1, 255);
        m.setElement(2, cv / 256 & 0xFF);
        m.setElement(3, cv & 0xFF);
        if (mode.equals(ProgrammingMode.PAGEMODE)) {
            m.setElement(4, 2);
        } else if (mode.equals(ProgrammingMode.DIRECTBITMODE)) {
            m.setElement(4, 1);
        } else if (mode.equals(ProgrammingMode.DIRECTBYTEMODE)) {
            m.setElement(4, 0);
        } else {
            m.setElement(4, 3);
        }
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getVerifyCV(int cv, ProgrammingMode mode, int startVal, int header) {
        CanMessage m = new CanMessage(6, header);
        m.setElement(0, 164);
        m.setElement(1, 255);
        m.setElement(2, cv / 256 & 0xFF);
        m.setElement(3, cv & 0xFF);
        if (mode.equals(ProgrammingMode.PAGEMODE)) {
            m.setElement(4, 2);
        } else if (mode.equals(ProgrammingMode.DIRECTBITMODE)) {
            m.setElement(4, 1);
        } else if (mode.equals(ProgrammingMode.DIRECTBYTEMODE)) {
            m.setElement(4, 0);
        } else {
            m.setElement(4, 3);
        }
        m.setElement(5, startVal & 0xFF);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getWriteCV(int cv, int val, ProgrammingMode mode, int header) {
        CanMessage m = new CanMessage(6, header);
        m.setElement(0, 162);
        m.setElement(1, 255);
        m.setElement(2, cv / 256 & 0xFF);
        m.setElement(3, cv & 0xFF);
        if (mode.equals(ProgrammingMode.PAGEMODE)) {
            m.setElement(4, 2);
        } else if (mode.equals(ProgrammingMode.DIRECTBITMODE)) {
            m.setElement(4, 1);
        } else if (mode.equals(ProgrammingMode.DIRECTBYTEMODE)) {
            m.setElement(4, 0);
        } else {
            m.setElement(4, 3);
        }
        m.setElement(5, val);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getOpsModeWriteCV(int mAddress, boolean mLongAddr, int cv, int val, int header) {
        CanMessage m = new CanMessage(7, header);
        int address = mAddress;
        m.setElement(0, 193);
        if (mLongAddr) {
            address |= 0xC000;
        }
        m.setElement(1, address / 256);
        m.setElement(2, address & 0xFF);
        m.setElement(3, cv / 256 & 0xFF);
        m.setElement(4, cv & 0xFF);
        m.setElement(5, 5);
        m.setElement(6, val);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getRequestTrackOn(int header) {
        CanMessage m = new CanMessage(1, header);
        m.setElement(0, 9);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getRequestTrackOff(int header) {
        CanMessage m = new CanMessage(1, header);
        m.setElement(0, 8);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getBootEntry(int nn, int header) {
        CanMessage m = new CanMessage(3, header);
        m.setElement(0, 92);
        m.setElement(1, nn / 256 & 0xFF);
        m.setElement(2, nn & 0xFF);
        CbusMessage.setPri(m, 11);
        return m;
    }

    public static CanMessage getBootNop(int a, int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, a & 0xFF);
        m.setElement(1, a / 256 & 0xFF);
        m.setElement(2, a / 65536 & 0xFF);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 0);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootReset(int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 1);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootInitialise(int a, int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, a & 0xFF);
        m.setElement(1, a / 256 & 0xFF);
        m.setElement(2, a / 65536 & 0xFF);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 2);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootCheck(int c, int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 3);
        m.setElement(6, c & 0xFF);
        m.setElement(7, c >> 8 & 0xFF);
        return m;
    }

    public static CanMessage getBootTest(int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 4);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootDevId(int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 5);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootId(int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 6);
        m.setElement(6, 0);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootEnables(int enables, int header) {
        CanMessage m = new CanMessage(8, header);
        m.setExtended(true);
        m.setHeader(4);
        m.setElement(0, 0);
        m.setElement(1, 0);
        m.setElement(2, 0);
        m.setElement(3, 0);
        m.setElement(4, 29);
        m.setElement(5, 7);
        m.setElement(6, enables & 0xFF);
        m.setElement(7, 0);
        return m;
    }

    public static CanMessage getBootWriteData(int[] d, int header) {
        CanMessage m = new CanMessage(d.length, header);
        m.setExtended(true);
        m.setHeader(5);
        for (int i = 0; i < d.length; ++i) {
            m.setElement(i, d[i] & 0xFF);
        }
        return m;
    }

    public static CanMessage getBootWriteData(byte[] d, int header) {
        CanMessage m = new CanMessage(d.length, header);
        m.setExtended(true);
        m.setHeader(5);
        for (int i = 0; i < d.length; ++i) {
            m.setElement(i, d[i] & 0xFF);
        }
        return m;
    }

    public static boolean isBootWriteData(CanMessage m) {
        return m.isExtended() && m.getHeader() == 5;
    }

    public static boolean isBootError(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 0 && r.getNumDataElements() == 1;
    }

    public static boolean isBootDataError(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000005 && r.getElement(0) == 0 && r.getNumDataElements() == 1;
    }

    public static boolean isBootOK(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 1 && r.getNumDataElements() == 1;
    }

    public static boolean isBootDataOK(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000005 && r.getElement(0) == 1 && r.getNumDataElements() == 1;
    }

    public static boolean isBootOutOfRange(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 3 && r.getNumDataElements() == 1;
    }

    public static boolean isBootDataOutOfRange(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000005 && r.getElement(0) == 3 && r.getNumDataElements() == 1;
    }

    public static boolean isBootConfirm(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 2 && r.getNumDataElements() == 1;
    }

    public static boolean isBootDevId(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 5 && r.getNumDataElements() == 7;
    }

    public static boolean isBootId(CanReply r) {
        return r.isExtended() && r.getHeader() == 0x10000004 && r.getElement(0) == 6 && r.getNumDataElements() == 5;
    }
}

