/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.Disposable;
import jmri.JmriException;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.managers.AbstractPowerManager;

public class CbusPowerManager
extends AbstractPowerManager<CanSystemConnectionMemo>
implements CanListener,
Disposable {
    private TrafficController tc;

    public CbusPowerManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        this.checkTC();
        if (v == 2) {
            this.tc.sendCanMessage(CbusMessage.getRequestTrackOn(this.tc.getCanid()), this);
        } else if (v == 4) {
            this.tc.sendCanMessage(CbusMessage.getRequestTrackOff(this.tc.getCanid()), this);
        }
        this.firePowerPropertyChange(old, this.power);
    }

    public void updatePower(int newPower) {
        int oldPower = this.power;
        if (oldPower != newPower) {
            this.power = newPower;
            this.firePowerPropertyChange(oldPower, this.power);
        }
    }

    @Override
    public void dispose() {
        this.removeTc(this.tc);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use CbusPowerManager after dispose");
        }
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int old = this.power;
        if (CbusMessage.isTrackOff(m)) {
            this.power = 4;
        } else if (CbusMessage.isTrackOn(m)) {
            this.power = 2;
        } else if (CbusMessage.isArst(m) && ((CanSystemConnectionMemo)this.memo).powerOnArst()) {
            this.power = 2;
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void message(CanMessage m) {
    }
}

