/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.BooleanPropertyDescriptor;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.Reporter;
import jmri.SelectionPropertyDescriptor;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusReporter;
import jmri.managers.AbstractReporterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusReporterManager
extends AbstractReporterManager {
    protected static final String CBUS_REPORTER_DESCRIPTOR_KEY = "CBUS Reporter Type";
    protected static final String CBUS_REPORTER_TYPE_CLASSIC = "Classic RFID";
    protected static final String CBUS_REPORTER_TYPE_DDES_DESCRIBING = "CANRC522 / CANRCOM";
    static final String[] CBUS_REPORTER_TYPES = new String[]{"Classic RFID", "CANRC522 / CANRCOM"};
    static final String[] CBUS_REPORTER_TYPE_TIPS = new String[]{"DDES / ACDAT 5 byte unique tag.", "DDES self-describing ( Writeable CANRC522 / Railcom )"};
    protected static final String CBUS_DEFAULT_REPORTER_TYPE = CBUS_REPORTER_TYPES[0];
    protected static final String CBUS_MAINTAIN_SENSOR_DESCRIPTOR_KEY = "Maintain CBUS Sensor";
    private int _timeout = 2000;
    private static final Logger log = LoggerFactory.getLogger(CbusReporterManager.class);

    public CbusReporterManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public CanSystemConnectionMemo getMemo() {
        return (CanSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("ReporterManager create new CbusReporter: {}", (Object)systemName);
        String addr = systemName.substring(this.getSystemNamePrefix().length());
        CbusReporter t = new CbusReporter(addr, this.getMemo());
        t.setUserName(userName);
        t.addPropertyChangeListener(this);
        return t;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        log.debug("Checking system name: {}", (Object)systemName);
        try {
            int testnum = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1, systemName.length()));
            if (testnum < 0) {
                log.debug("Number field cannot be negative in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (testnum > 65535) {
                log.debug("Number field cannot be greater than 65535 in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        catch (NumberFormatException e) {
            log.debug("Illegal character in number field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        catch (StringIndexOutOfBoundsException e) {
            log.debug("Wrong length ( missing MR? ) for system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        log.debug("Valid system name: {}", (Object)systemName);
        return Manager.NameValidity.VALID;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddReporterEntryToolTip");
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        ArrayList l = new ArrayList();
        l.add(new SelectionPropertyDescriptor(CBUS_REPORTER_DESCRIPTOR_KEY, CBUS_REPORTER_TYPES, CBUS_REPORTER_TYPE_TIPS, CBUS_DEFAULT_REPORTER_TYPE){

            @Override
            public String getColumnHeaderText() {
                return CbusReporterManager.CBUS_REPORTER_DESCRIPTOR_KEY;
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return bean instanceof CbusReporter;
            }
        });
        l.add(new BooleanPropertyDescriptor(CBUS_MAINTAIN_SENSOR_DESCRIPTOR_KEY, false){

            @Override
            public String getColumnHeaderText() {
                return CbusReporterManager.CBUS_MAINTAIN_SENSOR_DESCRIPTOR_KEY;
            }

            @Override
            public boolean isEditable(NamedBean bean) {
                return bean instanceof CbusReporter;
            }
        });
        return l;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public int getTimeout() {
        return this._timeout;
    }
}

