/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.TextAreaFIFO;

public class CbusSend {
    private TrafficController tc;
    private final CanSystemConnectionMemo memo;
    private final TextAreaFIFO ta;
    private final String newLine = System.getProperty("line.separator");

    public CbusSend(@Nonnull CanSystemConnectionMemo systemMemo, TextAreaFIFO txta) {
        this.memo = systemMemo;
        this.tc = this.memo.getTrafficController();
        this.ta = txta;
    }

    public CbusSend(CanSystemConnectionMemo systemMemo) {
        this.memo = systemMemo;
        if (this.memo != null) {
            this.tc = this.memo.getTrafficController();
        }
        this.ta = null;
    }

    public void sendWithDelay(CanReply r, Boolean sendReply, Boolean sendMessage, int delay) {
        CbusMessage.setId(r, this.tc.getCanid());
        CbusMessage.setPri(r, 11);
        ThreadingUtil.runOnLayoutDelayed(() -> {
            if (sendReply.booleanValue()) {
                this.tc.sendCanReply(r, null);
            }
            if (sendMessage.booleanValue()) {
                CanMessage m = new CanMessage(r);
                this.tc.sendCanMessage(m, null);
            }
        }, delay);
    }

    public void nodeExitLearnEvMode(int nn) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 84);
        m.setElement(1, nn >> 8);
        m.setElement(2, nn & 0xFF);
        this.tc.sendCanMessage(m, null);
        if (this.ta != null) {
            this.ta.append(this.newLine + Bundle.getMessage("NdReqExitLearn", nn));
        }
    }

    public void nodeEnterLearnEvMode(int nn) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 83);
        m.setElement(1, nn >> 8);
        m.setElement(2, nn & 0xFF);
        this.tc.sendCanMessage(m, null);
        if (this.ta != null) {
            this.ta.append(this.newLine + Bundle.getMessage("NdReqEnterLearn", nn));
        }
    }

    public void nodeSetNodeNumber(int nn) {
        CanMessage mn = new CanMessage(this.tc.getCanid());
        mn.setNumDataElements(3);
        CbusMessage.setPri(mn, 11);
        mn.setElement(0, 66);
        mn.setElement(1, nn >> 8);
        mn.setElement(2, nn & 0xFF);
        this.tc.sendCanMessage(mn, null);
    }

    public void nodeRequestParamSetup() {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 16);
        this.tc.sendCanMessage(m, null);
    }

    public void nodeTeachEventLearnMode(int newvalnd, int newevent, int varindex, int newval) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        CbusMessage.setPri(m, 11);
        m.setNumDataElements(7);
        m.setElement(0, 210);
        m.setElement(1, newvalnd >> 8);
        m.setElement(2, newvalnd & 0xFF);
        m.setElement(3, newevent >> 8);
        m.setElement(4, newevent & 0xFF);
        m.setElement(5, varindex);
        m.setElement(6, newval);
        this.tc.sendCanMessage(m, null);
    }

    public void nodeUnlearnEvent(int newvalnd, int newevent) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(5);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 149);
        m.setElement(1, newvalnd >> 8);
        m.setElement(2, newvalnd & 0xFF);
        m.setElement(3, newevent >> 8);
        m.setElement(4, newevent & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void rEVAL(int nodeinsetup, int nextev, int nextevvar) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(5);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 156);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        m.setElement(3, nextev);
        m.setElement(4, nextevvar);
        this.tc.sendCanMessage(m, null);
    }

    public void rQNPN(int nodeinsetup, int nextnodeparam) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(4);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 115);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        m.setElement(3, nextnodeparam);
        this.tc.sendCanMessage(m, null);
    }

    public void searchForNodes() {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 13);
        this.tc.sendCanMessage(m, null);
    }

    public void searchForCommandStations() {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 12);
        this.tc.sendCanMessage(m, null);
    }

    public void nVRD(int nodeinsetup, int nextnodenv) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(4);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 113);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        m.setElement(3, nextnodenv);
        this.tc.sendCanMessage(m, null);
    }

    public void nVSET(int nodeinsetup, int nv, int newval) {
        if (this.getNvWriteLearnMode(nodeinsetup)) {
            this.nodeEnterLearnEvMode(nodeinsetup);
        }
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(5);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 150);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        m.setElement(3, nv);
        m.setElement(4, newval);
        this.tc.sendCanMessage(m, null);
        if (this.getNvWriteLearnMode(nodeinsetup)) {
            this.nodeExitLearnEvMode(nodeinsetup);
        }
    }

    private boolean getNvWriteLearnMode(int nodeinsetup) {
        CbusNode nd;
        CbusNodeTableDataModel model = this.getNodeModel();
        if (model != null && (nd = model.getNodeByNodeNum(nodeinsetup)) != null) {
            return nd.getnvWriteInLearnOnly();
        }
        return false;
    }

    @CheckForNull
    private CbusNodeTableDataModel getNodeModel() {
        if (this.memo != null) {
            return (CbusNodeTableDataModel)this.memo.getFromMap(CbusNodeTableDataModel.class);
        }
        return null;
    }

    public void rQEVN(int nodeinsetup) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 88);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void nERD(int nodeinsetup) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 87);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void aRST() {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 7);
        this.tc.sendCanMessage(m, null);
    }

    public void eNUM(int nodeinsetup) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 93);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void cANID(int nodeinsetup, int canid) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(4);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 117);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        m.setElement(3, canid & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void nNCLR(int nodeinsetup) {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(3);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 85);
        m.setElement(1, nodeinsetup >> 8);
        m.setElement(2, nodeinsetup & 0xFF);
        this.tc.sendCanMessage(m, null);
    }

    public void rQmn() {
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 17);
        this.tc.sendCanMessage(m, null);
    }
}

