/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.JmriException;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusEventInterface;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSensor
extends AbstractSensor
implements CanListener,
CbusEventInterface {
    private CbusAddress addrActive;
    private CbusAddress addrInactive;
    private final TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(CbusSensor.class);

    public CbusSensor(String prefix, String address, TrafficController tc) {
        super(prefix + "S" + address);
        this.tc = tc;
        this.init(address);
    }

    private void init(String address) {
        CbusAddress a = new CbusAddress(address);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 1: {
                this.addrActive = v[0];
                if (address.startsWith("+")) {
                    this.addrInactive = new CbusAddress("-" + address.substring(1));
                    break;
                }
                if (address.startsWith("-")) {
                    this.addrInactive = new CbusAddress("+" + address.substring(1));
                    break;
                }
                log.error("can't make 2nd event from systemname {}", (Object)address);
                return;
            }
            case 2: {
                this.addrActive = v[0];
                this.addrInactive = v[1];
                break;
            }
            default: {
                log.error("Can't parse CbusSensor system name: {}", (Object)address);
                return;
            }
        }
        this.addTc(this.tc);
    }

    @Override
    public void requestUpdateFromLayout() {
        CanMessage m = this.addrActive.makeMessage(this.tc.getCanid());
        int opc = CbusMessage.getOpcode(m);
        if (CbusOpCodes.isShortEvent(opc)) {
            m.setOpCode(154);
        } else {
            m.setOpCode(146);
        }
        CbusMessage.setPri(m, 11);
        this.tc.sendCanMessage(m, this);
    }

    @Override
    public void setKnownState(int s) throws JmriException {
        CanMessage m;
        this.setOwnState(s);
        switch (s) {
            case 2: {
                m = this.getInverted() ? this.addrInactive.makeMessage(this.tc.getCanid()) : this.addrActive.makeMessage(this.tc.getCanid());
                break;
            }
            case 4: {
                m = !this.getInverted() ? this.addrInactive.makeMessage(this.tc.getCanid()) : this.addrActive.makeMessage(this.tc.getCanid());
                break;
            }
            default: {
                return;
            }
        }
        CbusMessage.setPri(m, 11);
        this.tc.sendCanMessage(m, this);
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    public CanMessage getAddrActive() {
        CanMessage m = this.getInverted() ? this.addrInactive.makeMessage(this.tc.getCanid()) : this.addrActive.makeMessage(this.tc.getCanid());
        return m;
    }

    public CanMessage getAddrInactive() {
        CanMessage m = this.getInverted() ? this.addrActive.makeMessage(this.tc.getCanid()) : this.addrInactive.makeMessage(this.tc.getCanid());
        return m;
    }

    @Override
    public CanMessage getBeanOnMessage() {
        return this.checkEvent(this.getAddrActive());
    }

    @Override
    public CanMessage getBeanOffMessage() {
        return this.checkEvent(this.getAddrInactive());
    }

    @Override
    public void message(CanMessage f) {
        if (f.extendedOrRtr()) {
            return;
        }
        if (this.addrActive.match(f)) {
            this.setOwnState(!this.getInverted() ? 2 : 4);
        } else if (this.addrInactive.match(f)) {
            this.setOwnState(!this.getInverted() ? 4 : 2);
        }
    }

    @Override
    public void reply(CanReply f) {
        if (f.extendedOrRtr()) {
            return;
        }
        CanReply opcf = CbusMessage.opcRangeToStl(f);
        if (this.addrActive.match(opcf)) {
            this.setOwnState(!this.getInverted() ? 2 : 4);
        } else if (this.addrInactive.match(opcf)) {
            this.setOwnState(!this.getInverted() ? 4 : 2);
        }
    }

    @Override
    public void dispose() {
        this.tc.removeCanListener(this);
        super.dispose();
    }
}

