/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.beans.PropertyChangeEvent;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusSensor;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSensorManager
extends AbstractSensorManager {
    private static final Logger log = LoggerFactory.getLogger(CbusSensorManager.class);

    public CbusSensorManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String newAddress;
        String addr = systemName.substring(this.getSystemNamePrefix().length());
        try {
            newAddress = CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to create CbusSensor, {}", (Object)e.getMessage());
            throw e;
        }
        CbusSensor s = new CbusSensor(this.getSystemPrefix(), newAddress, ((CanSystemConnectionMemo)this.getMemo()).getTrafficController());
        s.setUserName(userName);
        return s;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        String newAddress;
        try {
            this.validateSystemNamePrefix(prefix + this.typeLetter() + curAddress, Locale.getDefault());
            newAddress = CbusAddress.validateSysName(curAddress);
        }
        catch (IllegalArgumentException e) {
            throw new JmriException(e.getMessage());
        }
        return prefix + this.typeLetter() + newAddress;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        if (!this.allowMultipleAdditions(currentBean.getSystemName())) {
            throw new UnsupportedOperationException("Not supported");
        }
        String currentName = currentBean.getSystemName();
        String suffix = Manager.getSystemSuffix(currentName);
        String type = Manager.getTypeLetter(currentName);
        String prefix = Manager.getSystemPrefix(currentName);
        String nextName = CbusAddress.getIncrement(suffix);
        if (nextName == null) {
            throw new JmriException("No existing number found when incrementing " + currentName);
        }
        return prefix + type + nextName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        this.validateSystemNamePrefix(name, locale);
        try {
            return this.getSystemNamePrefix() + CbusAddress.validateSysName(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (IllegalArgumentException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", ex.getMessage());
        }
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        try {
            String addr = systemName.substring(this.getSystemNamePrefix().length());
            CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException e) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("inverted")) {
            this.firePropertyChange("beaninverted", null, null);
        }
    }
}

