/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import javax.swing.Timer;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleManager;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusCommandStation;
import jmri.jmrix.can.cbus.CbusConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusThrottle
extends AbstractThrottle {
    private CbusCommandStation cs = null;
    private int _handle = -1;
    private DccLocoAddress dccAddress = null;
    private boolean _isStolen;
    private int _recoveryAttempts;
    private int oldCbusSpeed = -2;
    private Timer mRefreshTimer;
    private static final Logger log = LoggerFactory.getLogger(CbusThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CbusThrottle(CanSystemConnectionMemo memo, LocoAddress address, int handle) {
        super(memo, CbusConstants.MAX_FUNCTIONS);
        log.debug("creating new CbusThrottle address {} handle {}", (Object)address, (Object)handle);
        if (!(address instanceof DccLocoAddress)) {
            log.error("{} is not a DccLocoAddress", (Object)address);
            return;
        }
        this.cs = (CbusCommandStation)this.adapterMemo.get(CommandStation.class);
        this._handle = handle;
        this._isStolen = false;
        this._recoveryAttempts = 0;
        CbusThrottle cbusThrottle = this;
        synchronized (cbusThrottle) {
            this.speedSetting = 0.0f;
        }
        this.dccAddress = (DccLocoAddress)address;
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        log.debug("Start Throttle refresh");
        this.startRefresh();
    }

    protected void throttleInit(int speed, int f0f4, int f5f8, int f9f12) {
        log.debug("Setting throttle initial values");
        this.updateSpeedSetting(speed & 0x7F);
        this.updateIsForward((speed & 0x80) == 128);
        this.updateFunctionGroup(1, f0f4);
        this.updateFunctionGroup(2, f5f8);
        this.updateFunctionGroup(3, f9f12);
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode stepMode) {
        int mode;
        if (this.speedStepMode == stepMode) {
            return;
        }
        super.setSpeedStepMode(stepMode);
        switch (this.speedStepMode) {
            case NMRA_DCC_28: {
                mode = 3;
                break;
            }
            case NMRA_DCC_14: {
                mode = 1;
                break;
            }
            default: {
                mode = 0;
            }
        }
        this.cs.setSpeedSteps(this._handle, mode);
    }

    protected float floatSpeed(int lSpeed) {
        if (this.getSpeedStepMode() == SpeedStepMode.NMRA_DCC_28) {
            float toReturn = 0.0f;
            switch (lSpeed) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    toReturn = -1.0f;
                    break;
                }
                default: {
                    toReturn = (float)(lSpeed - 3) / (float)this.speedStepMode.numSteps;
                }
            }
            return Math.min(toReturn, 1.0f);
        }
        switch (lSpeed) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return -1.0f;
            }
        }
        return (float)(lSpeed - 1) / (float)this.speedStepMode.numSteps;
    }

    @Override
    protected void sendFunctionGroup1() {
        this.sendFunctionGroup(1);
    }

    @Override
    protected void sendFunctionGroup2() {
        this.sendFunctionGroup(2);
    }

    @Override
    protected void sendFunctionGroup3() {
        this.sendFunctionGroup(3);
    }

    @Override
    protected void sendFunctionGroup4() {
        this.sendFunctionGroup(4);
    }

    @Override
    protected void sendFunctionGroup5() {
        this.sendFunctionGroup(5);
    }

    @Override
    protected void sendFunctionGroup6() {
        this.sendFunctionGroup(6);
    }

    protected void sendFunctionGroup(int group) {
        int totVal = 0;
        for (int i = 0; i < CbusConstants.MAX_FUNCTIONS; ++i) {
            if (FUNCTION_GROUPS[i] != group || !this.getFunction(i)) continue;
            totVal += CbusConstants.CBUS_FUNCTION_BITS[i];
        }
        this.cs.setFunctions(group, this._handle, totVal);
    }

    protected void updateFunctionGroup(int group, int fns) {
        for (int i = 0; i < CbusConstants.MAX_FUNCTIONS; ++i) {
            if (FUNCTION_GROUPS[i] != group) continue;
            this.updateFunction(i, (fns & CbusConstants.CBUS_FUNCTION_BITS[i]) == CbusConstants.CBUS_FUNCTION_BITS[i]);
        }
    }

    @Override
    public synchronized void setSpeedSetting(float speed, boolean allowDuplicates, boolean allowDuplicatesOnStop) {
        log.debug("setSpeedSetting({})", (Object)Float.valueOf(speed));
        float oldSpeed = this.speedSetting;
        this.speedSetting = speed;
        if (speed < 0.0f) {
            this.speedSetting = -1.0f;
        }
        this.setDispatchActive(this.speedSetting > 0.0f);
        if (this.oldCbusSpeed != this.getCbusSpeedDirection() || allowDuplicates || speed == 0.0f && allowDuplicatesOnStop) {
            this.sendToLayout();
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
            this.record(this.speedSetting);
        }
    }

    private synchronized int getCbusSpeedFromFloat() {
        switch (this.speedStepMode) {
            case NMRA_DCC_28: {
                int ints = CbusThrottle.intSpeed(this.speedSetting, 29);
                if (ints > 1) {
                    ints += 2;
                }
                return ints;
            }
            case NMRA_DCC_14: {
                return CbusThrottle.intSpeed(this.speedSetting, 15);
            }
        }
        return this.intSpeed(this.speedSetting);
    }

    private synchronized int getCbusSpeedDirection() {
        int speed = this.getCbusSpeedFromFloat();
        if (this.isForward) {
            speed |= 0x80;
        }
        return speed;
    }

    private void sendToLayout() {
        this.oldCbusSpeed = this.getCbusSpeedDirection();
        log.debug("Sending speed/dir for speed: {}", (Object)this.oldCbusSpeed);
        this.mRefreshTimer.stop();
        this.mRefreshTimer.setRepeats(true);
        this.mRefreshTimer.start();
        if (this.cs != null) {
            this.cs.setSpeedDir(this._handle, this.oldCbusSpeed);
        }
    }

    protected synchronized void updateSpeedSetting(int speed) {
        log.debug("Updated speed/dir for speed:{}", (Object)speed);
        float oldSpeed = this.speedSetting;
        this.speedSetting = this.floatSpeed(speed);
        if (speed < 0) {
            this.speedSetting = -1.0f;
        }
        this.setDispatchActive(this.speedSetting > 0.0f);
        if ((double)Math.abs(oldSpeed - this.speedSetting) > 1.0E-4) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
            this.record(this.speedSetting);
        }
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        if (old != this.isForward) {
            this.sendToLayout();
            this.firePropertyChange("IsForward", old, this.isForward);
        }
    }

    protected void updateIsForward(boolean forward) {
        super.setIsForward(forward);
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    protected int getHandle() {
        return this._handle;
    }

    protected void setHandle(int newHandle) {
        this._handle = newHandle;
    }

    protected void setStolen(boolean isStolen) {
        if (isStolen != this._isStolen) {
            this.firePropertyChange("IsAvailable", isStolen, this._isStolen);
            this._isStolen = isStolen;
        }
        if (isStolen) {
            if (this.mRefreshTimer != null) {
                this.mRefreshTimer.stop();
            }
            this.mRefreshTimer = null;
        } else {
            this.startRefresh();
        }
    }

    protected boolean isStolen() {
        return this._isStolen;
    }

    protected int getNumRecoverAttempts() {
        return this._recoveryAttempts;
    }

    protected void increaseNumRecoverAttempts() {
        ++this._recoveryAttempts;
    }

    protected void resetNumRecoverAttempts() {
        this._recoveryAttempts = 0;
    }

    protected void releaseFromCommandStation() {
        if (this.cs != null) {
            this.cs.releaseSession(this._handle);
        }
    }

    @Override
    public void throttleDispose() {
        log.debug("dispose");
        this.finishRecord();
        this.notifyThrottleDisconnect();
        if (this.mRefreshTimer != null) {
            this.mRefreshTimer.stop();
        }
        this.mRefreshTimer = null;
        this.cs = null;
        this._handle = -1;
    }

    protected final void startRefresh() {
        this.mRefreshTimer = new Timer(4000, e -> this.keepAlive());
        this.mRefreshTimer.setRepeats(true);
        this.mRefreshTimer.start();
    }

    private synchronized void keepAlive() {
        if (this.cs != null) {
            this.cs.sendKeepAlive(this._handle);
            this.mRefreshTimer.stop();
            this.mRefreshTimer.setRepeats(true);
            this.mRefreshTimer.start();
        }
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.dccAddress;
    }

    protected void setDispatchActive(boolean newval) {
        if (this.cs == null) {
            return;
        }
        if (this.cs.getMasterCommandStation() == null) {
            return;
        }
        if (newval) {
            int numThrottles = this.adapterMemo.get(ThrottleManager.class).getThrottleUsageCount(this.dccAddress);
            log.debug("numThrottles {}", (Object)numThrottles);
            if (numThrottles < 2) {
                this.notifyThrottleReleaseEnabled(false);
                this.notifyThrottleDispatchEnabled(true);
                return;
            }
        }
        this.notifyThrottleReleaseEnabled(true);
        this.notifyThrottleDispatchEnabled(false);
    }
}

