/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.util.EnumSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusCommandStation;
import jmri.jmrix.can.cbus.CbusThrottle;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusThrottleManager
extends AbstractThrottleManager
implements CanListener,
Disposable {
    private boolean _handleExpected = false;
    private boolean _handleExpectedSecondLevelRequest = false;
    private int _intAddr;
    private DccLocoAddress _dccAddr;
    protected int THROTTLE_TIMEOUT = 5000;
    private boolean canErrorDialogVisible;
    private boolean invalidErrorDialogVisible;
    private boolean _singleThrottleInUse = false;
    private final ConcurrentHashMap<Integer, CbusThrottle> softThrottles = new ConcurrentHashMap(32);
    private final TrafficController tc;
    private final CanSystemConnectionMemo memo;
    private TimerTask throttleRequestTimer;
    private static final Logger log = LoggerFactory.getLogger(CbusThrottleManager.class);

    public CbusThrottleManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.memo = memo;
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
    }

    @Override
    public void dispose() {
        this.removeTc(this.tc);
        this.stopThrottleRequestTimer();
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        this.startThrottleRequestTimer(false);
        this.requestThrottleSetup(address, ThrottleListener.DecisionType.STEAL_OR_SHARE);
    }

    private void requestThrottleSetup(LocoAddress address, ThrottleListener.DecisionType decision) {
        if (!(address instanceof DccLocoAddress)) {
            log.error("{} is not a DccLocoAddress", (Object)address);
            return;
        }
        if (this.memo.hasMultipleThrottles() || !this._singleThrottleInUse) {
            CanMessage msg;
            this._dccAddr = (DccLocoAddress)address;
            this._intAddr = this._dccAddr.getNumber();
            log.debug("Requesting {} session for loco {}", (Object)decision, (Object)this._dccAddr);
            if (this._dccAddr.isLongAddress()) {
                this._intAddr |= 0xC000;
            }
            switch (decision) {
                case STEAL_OR_SHARE: {
                    this._handleExpectedSecondLevelRequest = false;
                    msg = new CanMessage(3, this.tc.getCanid());
                    msg.setOpCode(64);
                    msg.setElement(1, this._intAddr / 256);
                    msg.setElement(2, this._intAddr & 0xFF);
                    break;
                }
                case STEAL: {
                    this._handleExpectedSecondLevelRequest = true;
                    msg = new CanMessage(4, this.tc.getCanid());
                    msg.setOpCode(97);
                    msg.setElement(1, this._intAddr / 256);
                    msg.setElement(2, this._intAddr & 0xFF);
                    msg.setElement(3, 1);
                    break;
                }
                case SHARE: {
                    this._handleExpectedSecondLevelRequest = true;
                    msg = new CanMessage(4, this.tc.getCanid());
                    msg.setOpCode(97);
                    msg.setElement(1, this._intAddr / 256);
                    msg.setElement(2, this._intAddr & 0xFF);
                    msg.setElement(3, 2);
                    break;
                }
                default: {
                    log.error("decision type {} unknown to CbusThrottleManager", (Object)decision);
                    return;
                }
            }
            this._handleExpected = true;
            this.tc.sendCanMessage(msg, this);
        } else {
            this.failedThrottleRequest(address, "Only one Throttle can be in use at anyone time with this connection.");
            log.warn("Single CBUS Throttle already in use");
        }
    }

    private void stopAll() {
        for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
            CbusThrottle throttle = entry.getValue();
            throttle.setSpeedSetting(-1.0f);
        }
    }

    @Override
    public void message(CanMessage m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = m.getElement(0);
        switch (opc) {
            case 6: 
            case 10: {
                this.stopAll();
                break;
            }
            case 33: {
                log.debug("Kill loco message");
                int handle = m.getElement(1);
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.throttleDispose();
                    this.forceDisposeThrottle(throttle.getLocoAddress());
                    this.softThrottles.remove(throttle.getHandle());
                }
                this._singleThrottleInUse = false;
                break;
            }
            case 71: {
                if ((m.getElement(2) & 0x7F) != 1) break;
                int handle = m.getElement(1);
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.updateSpeedSetting(m.getElement(2) & 0x7F);
                    throttle.updateIsForward((m.getElement(2) & 0x80) == 128);
                }
                break;
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT", "SLF4J_FORMAT_SHOULD_BE_CONST"})
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = m.getElement(0);
        int handle = m.getElement(1);
        switch (opc) {
            case 225: {
                int rcvdIntAddr = (m.getElement(2) & 0x3F) * 256 + m.getElement(3);
                boolean rcvdIsLong = (m.getElement(2) & 0xC0) != 0;
                DccLocoAddress rcvdDccAddr = new DccLocoAddress(rcvdIntAddr, rcvdIsLong);
                log.debug("Throttle manager received PLOC with session {} for address {}", (Object)m.getElement(1), (Object)rcvdIntAddr);
                if (!this._handleExpected || !rcvdDccAddr.equals(this._dccAddr)) break;
                log.debug("PLOC was expected");
                this.stopThrottleRequestTimer();
                handle = m.getElement(1);
                if (!this.memo.hasMultipleThrottles()) {
                    this._singleThrottleInUse = true;
                }
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (!throttle.isStolen()) continue;
                    log.debug("setting handle from {} to {}", (Object)throttle.getHandle(), (Object)handle);
                    throttle.setHandle(handle);
                    throttle.setStolen(false);
                    throttle.throttleInit(m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7));
                    this._handleExpected = false;
                    return;
                }
                CbusThrottle throttle = new CbusThrottle((CanSystemConnectionMemo)this.adapterMemo, rcvdDccAddr, handle);
                this.notifyThrottleKnown(throttle, rcvdDccAddr);
                throttle.throttleInit(m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7));
                this.softThrottles.put(handle, throttle);
                this._handleExpected = false;
                break;
            }
            case 99: {
                this.handleErr(m);
                break;
            }
            case 71: {
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.updateSpeedSetting(m.getElement(2) & 0x7F);
                    throttle.updateIsForward((m.getElement(2) & 0x80) == 128);
                    throttle.setDispatchActive(false);
                }
                break;
            }
            case 96: {
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.setDispatchActive(false);
                    throttle.updateFunctionGroup(m.getElement(2), m.getElement(3));
                }
                break;
            }
            case 73: 
            case 74: {
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.setDispatchActive(false);
                    throttle.updateFunction(m.getElement(2), opc == 73);
                }
                break;
            }
            case 6: 
            case 10: {
                this.stopAll();
                break;
            }
            case 35: {
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    throttle.setDispatchActive(false);
                }
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    private void handleErr(CanReply m) {
        int handle = m.getElement(1);
        int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
        boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
        int errCode = m.getElement(3);
        boolean responseForUs = this._handleExpected && new DccLocoAddress(rcvdIntAddr, rcvdIsLong).equals(this._dccAddr);
        block0 : switch (errCode) {
            case 1: 
            case 2: {
                Object errStr = errCode == 1 ? Bundle.getMessage("ERR_LOCO_STACK_FULL") + " " + rcvdIntAddr : Bundle.getMessage("ERR_LOCO_ADDRESS_TAKEN", rcvdIntAddr);
                if (responseForUs) {
                    log.debug("Failed throttle request due to ERR");
                    this._handleExpected = false;
                    this.stopThrottleRequestTimer();
                    if (this._handleExpectedSecondLevelRequest) {
                        this.failedThrottleRequest(this._dccAddr, (String)errStr);
                        return;
                    }
                    boolean steal = false;
                    boolean share = false;
                    CbusCommandStation cs = (CbusCommandStation)this.memo.get(CommandStation.class);
                    if (cs != null) {
                        log.debug("cs says can steal {}, can share {}", (Object)cs.isStealAvailable(), (Object)cs.isShareAvailable());
                        steal = cs.isStealAvailable();
                        share = cs.isShareAvailable();
                    }
                    if (!steal && !share) {
                        this.failedThrottleRequest(this._dccAddr, (String)errStr);
                        break;
                    }
                    if (steal && share) {
                        this.notifyDecisionRequest(this._dccAddr, ThrottleListener.DecisionType.STEAL_OR_SHARE);
                        break;
                    }
                    if (steal) {
                        this.notifyDecisionRequest(this._dccAddr, ThrottleListener.DecisionType.STEAL);
                        break;
                    }
                    this.notifyDecisionRequest(this._dccAddr, ThrottleListener.DecisionType.SHARE);
                    break;
                }
                log.debug("ERR address not matched");
                break;
            }
            case 3: {
                log.warn("{}", (Object)Bundle.getMessage("ERR_SESSION_NOT_PRESENT", handle));
                if (responseForUs) {
                    this._handleExpected = false;
                    this.failedThrottleRequest(this._dccAddr, Bundle.getMessage("CBUS_ERROR") + Bundle.getMessage("ERR_SESSION_NOT_PRESENT", handle));
                    log.warn("Session not present when expecting a session number");
                }
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    log.warn("Cancelling JMRI Throttle Session {} for loco {}", (Object)handle, (Object)throttle.getLocoAddress().toString());
                    this.attemptRecoverThrottle(throttle);
                    break block0;
                }
                break;
            }
            case 4: {
                log.warn("{} {}", (Object)Bundle.getMessage("ERR_CONSIST_EMPTY"), (Object)handle);
                break;
            }
            case 5: {
                log.warn("{} {}", (Object)Bundle.getMessage("ERR_LOCO_NOT_FOUND"), (Object)handle);
                break;
            }
            case 6: {
                log.error("{}", (Object)Bundle.getMessage("ERR_CAN_BUS_ERROR"));
                if (!GraphicsEnvironment.isHeadless() && !this.canErrorDialogVisible) {
                    this.canErrorDialogVisible = true;
                    ThreadingUtil.runOnGUI(() -> JmriJOptionPane.showMessageDialogNonModal(null, Bundle.getMessage("ERR_CAN_BUS_ERROR"), Bundle.getMessage("CBUS_ERROR"), 0, () -> {
                        this.canErrorDialogVisible = false;
                    }));
                }
                return;
            }
            case 7: {
                log.error("{}", (Object)Bundle.getMessage("ERR_INVALID_REQUEST"));
                if (!GraphicsEnvironment.isHeadless() && !this.invalidErrorDialogVisible) {
                    this.invalidErrorDialogVisible = true;
                    ThreadingUtil.runOnGUI(() -> JmriJOptionPane.showMessageDialogNonModal(null, Bundle.getMessage("ERR_INVALID_REQUEST"), Bundle.getMessage("CBUS_ERROR"), 0, () -> {
                        this.invalidErrorDialogVisible = false;
                    }));
                }
                return;
            }
            case 8: {
                log.debug("{}", (Object)Bundle.getMessage("ERR_SESSION_CANCELLED", handle));
                for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                    CbusThrottle throttle = entry.getValue();
                    if (throttle.getHandle() != handle) continue;
                    if (throttle.isStolen()) {
                        log.debug("external steal already actioned, returning");
                        return;
                    }
                    log.warn("External Steal / Cancel for loco {} Session {} ", (Object)throttle.getLocoAddress(), (Object)handle);
                    this.attemptRecoverThrottle(throttle);
                    break block0;
                }
                break;
            }
            default: {
                log.error("{} error code: {}", (Object)Bundle.getMessage("ERR_UNKNOWN"), (Object)errCode);
            }
        }
    }

    private void attemptRecoverThrottle(CbusThrottle throttle) {
        log.debug("start of recovery, current throttle stolen {} session {} num recovr attempts {} hashmap size {}", new Object[]{throttle.isStolen(), throttle.getHandle(), throttle.getNumRecoverAttempts(), this.softThrottles.size()});
        int oldhandle = throttle.getHandle();
        throttle.increaseNumRecoverAttempts();
        if (throttle.getNumRecoverAttempts() > 10) {
            this._handleExpected = false;
            throttle.throttleDispose();
            this.showSessionCancelDialogue(throttle.getLocoAddress());
            this.softThrottles.remove(oldhandle);
            this.forceDisposeThrottle(throttle.getLocoAddress());
        }
        throttle.setStolen(true);
        throttle.setHandle(-1);
        boolean steal = false;
        boolean share = false;
        CbusCommandStation cs = (CbusCommandStation)this.memo.get(CommandStation.class);
        if (cs != null) {
            log.debug("cs says can steal {}, can share {}", (Object)cs.isStealAvailable(), (Object)cs.isShareAvailable());
            steal = cs.isStealAvailable();
            share = cs.isShareAvailable();
        }
        if (share && InstanceManager.getDefault(ThrottlesPreferences.class).isSilentShare()) {
            log.info("Requesting Silent Share loco {} to regain a session", (Object)throttle.getLocoAddress());
            ThreadingUtil.runOnLayoutDelayed(() -> {
                this.startThrottleRequestTimer(true);
                this.requestThrottleSetup(throttle.getLocoAddress(), ThrottleListener.DecisionType.SHARE);
            }, 1000);
        } else if (steal && InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
            log.info("Requesting Silent Steal loco {} to regain a session", (Object)throttle.getLocoAddress());
            ThreadingUtil.runOnLayoutDelayed(() -> {
                this.startThrottleRequestTimer(true);
                this.requestThrottleSetup(throttle.getLocoAddress(), ThrottleListener.DecisionType.STEAL);
            }, 1000);
        } else {
            throttle.throttleDispose();
            this.showSessionCancelDialogue(throttle.getLocoAddress());
            this.softThrottles.remove(oldhandle);
            this.forceDisposeThrottle(throttle.getLocoAddress());
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address > 0;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address < 128;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    static boolean isLongAddress(int num) {
        return num >= 128;
    }

    @Override
    public boolean enablePrefSilentStealOption() {
        return true;
    }

    @Override
    public boolean enablePrefSilentShareOption() {
        return true;
    }

    @Override
    protected void makeHardwareDecision(LocoAddress address, ThrottleListener.DecisionType question) {
        switch (question) {
            case STEAL: {
                this.responseThrottleDecision(address, null, ThrottleListener.DecisionType.STEAL);
                break;
            }
            case SHARE: {
                this.responseThrottleDecision(address, null, ThrottleListener.DecisionType.SHARE);
                break;
            }
            default: {
                if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
                    this.responseThrottleDecision(address, null, ThrottleListener.DecisionType.STEAL);
                    break;
                }
                this.responseThrottleDecision(address, null, ThrottleListener.DecisionType.SHARE);
            }
        }
    }

    @Override
    public void responseThrottleDecision(LocoAddress address, ThrottleListener l, ThrottleListener.DecisionType decision) {
        log.debug("Received {} response for Loco {}, listener {}", new Object[]{decision, address, l});
        this.startThrottleRequestTimer(false);
        this.requestThrottleSetup(address, decision);
    }

    private void startThrottleRequestTimer(final boolean isRecovery) {
        this.throttleRequestTimer = new TimerTask(){

            @Override
            public void run() {
                CbusThrottleManager.this.timeout(isRecovery);
            }
        };
        TimerUtil.schedule(this.throttleRequestTimer, this.THROTTLE_TIMEOUT);
    }

    private void stopThrottleRequestTimer() {
        if (this.throttleRequestTimer != null) {
            this.throttleRequestTimer.cancel();
        }
        this.throttleRequestTimer = null;
    }

    private void timeout(boolean isRecovery) {
        log.debug("Throttle request (RLOC or PLOC) timed out");
        this.stopThrottleRequestTimer();
        if (isRecovery) {
            log.warn("Session recovery not possible for {}", (Object)this._dccAddr);
            this.forceDisposeThrottle(this._dccAddr);
            for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
                CbusThrottle throttle = entry.getValue();
                if (throttle.getLocoAddress() != this._dccAddr) continue;
                throttle.throttleDispose();
                this.showSessionCancelDialogue(this._dccAddr);
                this.softThrottles.remove(throttle.getHandle());
            }
        } else {
            this.failedThrottleRequest(this._dccAddr, Bundle.getMessage("ERR_THROTTLE_TIMEOUT"));
        }
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28, SpeedStepMode.NMRA_DCC_14);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("disposeThrottle called for {}", (Object)t);
        if (t instanceof CbusThrottle) {
            log.debug("Cbus Dispose calling abstract Throttle manager dispose");
            if (super.disposeThrottle(t, l)) {
                CbusThrottle lnt = (CbusThrottle)t;
                lnt.releaseFromCommandStation();
                lnt.throttleDispose();
                log.debug("called throttleDispose");
                this._singleThrottleInUse = false;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void forceDisposeThrottle(LocoAddress la) {
        super.forceDisposeThrottle(la);
        this._singleThrottleInUse = false;
    }

    @Override
    protected void updateNumUsers(LocoAddress la, int numUsers) {
        log.debug("throttle {} notification that num. users is now {}", (Object)la, (Object)numUsers);
        for (Map.Entry<Integer, CbusThrottle> entry : this.softThrottles.entrySet()) {
            CbusThrottle throttle = entry.getValue();
            if (throttle.getLocoAddress() != la) continue;
            if (numUsers == 1 && throttle.getSpeedSetting() > 0.0f) {
                throttle.setDispatchActive(true);
                return;
            }
            throttle.setDispatchActive(false);
        }
    }

    @Override
    public void cancelThrottleRequest(LocoAddress address, ThrottleListener l) {
        super.cancelThrottleRequest(address, l);
        this.failedThrottleRequest(address, "Throttle Request " + address + " Cancelled.");
    }
}

