/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusEventInterface;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusTurnout
extends AbstractTurnout
implements CanListener,
CbusEventInterface {
    private CbusAddress addrThrown;
    private CbusAddress addrClosed;
    private final TrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(CbusTurnout.class);

    protected CbusTurnout(String prefix, String address, TrafficController tc) {
        super(prefix + "T" + address);
        this.tc = tc;
        this.init(address);
    }

    private void init(String address) {
        CbusAddress a = new CbusAddress(address);
        CbusAddress[] v = a.split();
        switch (v.length) {
            case 1: {
                this.addrThrown = v[0];
                if (address.startsWith("+")) {
                    this.addrClosed = new CbusAddress("-" + address.substring(1));
                    break;
                }
                if (address.startsWith("-")) {
                    this.addrClosed = new CbusAddress("+" + address.substring(1));
                    break;
                }
                log.error("can't make 2nd event from systemname {}", (Object)address);
                return;
            }
            case 2: {
                this.addrThrown = v[0];
                this.addrClosed = v[1];
                break;
            }
            default: {
                log.error("Can't parse CbusTurnout system name: {}", (Object)address);
                return;
            }
        }
        this.addTc(this.tc);
    }

    @Override
    public void requestUpdateFromLayout() {
        CanMessage m = this.addrThrown.makeMessage(this.tc.getCanid());
        if (CbusOpCodes.isShortEvent(CbusMessage.getOpcode(m))) {
            m.setOpCode(154);
        } else {
            m.setOpCode(146);
        }
        CbusMessage.setPri(m, 11);
        this.tc.sendCanMessage(m, this);
        super.requestUpdateFromLayout();
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        CanMessage m;
        if (newState == 4) {
            m = this.getAddrThrown();
            CbusMessage.setPri(m, 11);
            this.tc.sendCanMessage(m, this);
        }
        if (newState == 2) {
            m = this.getAddrClosed();
            CbusMessage.setPri(m, 11);
            this.tc.sendCanMessage(m, this);
        }
    }

    public CanMessage getAddrThrown() {
        CanMessage m = this.getInverted() ? this.addrClosed.makeMessage(this.tc.getCanid()) : this.addrThrown.makeMessage(this.tc.getCanid());
        return m;
    }

    public CanMessage getAddrClosed() {
        CanMessage m = this.getInverted() ? this.addrThrown.makeMessage(this.tc.getCanid()) : this.addrClosed.makeMessage(this.tc.getCanid());
        return m;
    }

    private void sendResponseToQuery() {
        CanMessage m = null;
        if (this.getCommandedState() == 4) {
            m = this.getAddrThrown();
            if (CbusMessage.isShort(m)) {
                if (CbusMessage.getEventType(m) == 0) {
                    m.setOpCode(157);
                } else {
                    m.setOpCode(158);
                }
            } else if (CbusMessage.getEventType(m) == 0) {
                m.setOpCode(147);
            } else {
                m.setOpCode(148);
            }
        } else if (this.getCommandedState() == 2) {
            m = this.getAddrThrown();
            if (CbusMessage.isShort(m)) {
                if (CbusMessage.getEventType(m) == 0) {
                    m.setOpCode(158);
                } else {
                    m.setOpCode(157);
                }
            } else if (CbusMessage.getEventType(m) == 0) {
                m.setOpCode(148);
            } else {
                m.setOpCode(147);
            }
        }
        if (m != null) {
            CbusMessage.setPri(m, 11);
            this.tc.sendCanMessage(m, this);
        }
    }

    @Override
    public void message(CanMessage f) {
        if (f.isExtended() || f.isRtr()) {
            return;
        }
        if (this.addrThrown.match(f)) {
            int state = !this.getInverted() ? 4 : 2;
            this.newCommandedState(state);
            if (this._activeFeedbackType == 1) {
                this.newKnownState(state);
            } else if (this._activeFeedbackType == 128) {
                this.newKnownState(8);
                ThreadingUtil.runOnLayoutDelayed(() -> this.newKnownState(state), DELAYED_FEEDBACK_INTERVAL);
            }
        } else if (this.addrClosed.match(f)) {
            int state = !this.getInverted() ? 2 : 4;
            this.newCommandedState(state);
            if (this._activeFeedbackType == 1) {
                this.newKnownState(state);
            } else if (this._activeFeedbackType == 128) {
                this.newKnownState(8);
                ThreadingUtil.runOnLayoutDelayed(() -> this.newKnownState(state), DELAYED_FEEDBACK_INTERVAL);
            }
        }
    }

    @Override
    public void reply(CanReply origf) {
        if (origf.extendedOrRtr()) {
            return;
        }
        CanReply f = CbusMessage.opcRangeToStl(origf);
        if (this.addrThrown.match(f)) {
            int state = !this.getInverted() ? 4 : 2;
            this.newCommandedState(state);
            if (this._activeFeedbackType == 1) {
                this.newKnownState(state);
            } else if (this._activeFeedbackType == 128) {
                this.newKnownState(8);
                ThreadingUtil.runOnLayoutDelayed(() -> this.newKnownState(state), DELAYED_FEEDBACK_INTERVAL);
            }
        } else if (this.addrClosed.match(f)) {
            int state = !this.getInverted() ? 2 : 4;
            this.newCommandedState(state);
            if (this._activeFeedbackType == 1) {
                this.newKnownState(state);
            } else if (this._activeFeedbackType == 128) {
                this.newKnownState(8);
                ThreadingUtil.runOnLayoutDelayed(() -> this.newKnownState(state), DELAYED_FEEDBACK_INTERVAL);
            }
        } else if (this.addrThrown.matchRequest(f)) {
            this.sendResponseToQuery();
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean locked) {
    }

    @Override
    public boolean canInvert() {
        return true;
    }

    @Override
    public CanMessage getBeanOnMessage() {
        return this.checkEvent(this.getAddrClosed());
    }

    @Override
    public CanMessage getBeanOffMessage() {
        return this.checkEvent(this.getAddrThrown());
    }

    @Override
    public void dispose() {
        this.tc.removeCanListener(this);
        super.dispose();
    }
}

