/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus;

import java.beans.PropertyChangeEvent;
import java.util.Locale;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.Bundle;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusTurnoutManager
extends AbstractTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(CbusTurnoutManager.class);

    public CbusTurnoutManager(CanSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String newAddress;
        String addr = systemName.substring(this.getSystemPrefix().length() + 1);
        try {
            newAddress = CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to create CbusTurnout, {}", (Object)e.getMessage());
            throw e;
        }
        CbusTurnout t = new CbusTurnout(this.getSystemPrefix(), newAddress, ((CanSystemConnectionMemo)this.getMemo()).getTrafficController());
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) {
        String newAddress;
        try {
            newAddress = CbusAddress.validateSysName(curAddress);
        }
        catch (IllegalArgumentException e) {
            newAddress = curAddress;
        }
        return prefix + this.typeLetter() + newAddress;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String getNextValidSystemName(@Nonnull NamedBean currentBean) throws JmriException {
        if (!this.allowMultipleAdditions(currentBean.getSystemName())) {
            throw new UnsupportedOperationException("Not supported");
        }
        String currentName = currentBean.getSystemName();
        String suffix = Manager.getSystemSuffix(currentName);
        String type = Manager.getTypeLetter(currentName);
        String prefix = Manager.getSystemPrefix(currentName);
        String nextName = CbusAddress.getIncrement(suffix);
        if (nextName == null) {
            throw new JmriException("No existing number found when incrementing " + currentName);
        }
        return prefix + type + nextName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        this.validateSystemNamePrefix(name, locale);
        try {
            CbusAddress.validateSysName(name.substring(this.getSystemNamePrefix().length()));
        }
        catch (IllegalArgumentException ex) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", ex.getMessage());
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        String addr;
        try {
            addr = systemName.substring(this.getSystemPrefix().length() + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            return Manager.NameValidity.INVALID;
        }
        try {
            CbusAddress.validateSysName(addr);
        }
        catch (IllegalArgumentException e) {
            return Manager.NameValidity.INVALID;
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("inverted")) {
            this.firePropertyChange("beaninverted", null, null);
        }
    }
}

