/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.util.HashSet;
import java.util.Set;
import jmri.NamedBean;
import jmri.jmrix.can.cbus.CbusEventDataElements;

public class CbusEventBeanData {
    private final Set<NamedBean> _nbActiveA;
    private final Set<NamedBean> _nbActiveB;

    public CbusEventBeanData(Set<NamedBean> nbActiveA, Set<NamedBean> nbActiveB) {
        this._nbActiveA = nbActiveA;
        this._nbActiveB = nbActiveB;
    }

    public CbusEventBeanData(Set<NamedBean> nbActiveA, Set<NamedBean> nbActiveB, Set<NamedBean> nbInActiveA, Set<NamedBean> nbInActiveB, CbusEventDataElements.EvState state) {
        this._nbActiveA = state == CbusEventDataElements.EvState.ON ? nbActiveA : nbInActiveA;
        this._nbActiveB = state == CbusEventDataElements.EvState.ON ? nbActiveB : nbInActiveB;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this._nbActiveA.forEach(n -> this.appendFromNb((NamedBean)n, sb, true));
        this._nbActiveB.forEach(n -> this.appendFromNb((NamedBean)n, sb, false));
        return sb.toString().trim();
    }

    private void appendFromNb(NamedBean bean, StringBuilder sb, boolean beanOn) {
        sb.append(bean.getBeanType()).append(" ");
        sb.append(bean.describeState(beanOn ? 2 : 4)).append(": ");
        sb.append(bean.getDisplayName()).append(" ");
    }

    public Set<NamedBean> getActionA() {
        return new HashSet<NamedBean>(this._nbActiveA);
    }

    public Set<NamedBean> getActionB() {
        return new HashSet<NamedBean>(this._nbActiveB);
    }
}

