/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import jmri.LightManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventInterface;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.eventtable.Bundle;
import jmri.jmrix.can.cbus.eventtable.CbusBasicEventTableModel;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;

public class CbusEventTableAction
implements PropertyChangeListener {
    private final CbusBasicEventTableModel _model;
    protected boolean sessionConfirmDeleteRow = true;
    private final Class<?>[] classTypes = new Class[]{TurnoutManager.class, SensorManager.class, LightManager.class};

    public CbusEventTableAction(@Nonnull CbusBasicEventTableModel model) {
        this._model = model;
        this.addRemoveListenersToNbManagers(true);
    }

    private void linkHwaddtoEvent(NamedBean bean, boolean beanState, CanMessage m) {
        if (m == null) {
            return;
        }
        int en = CbusMessage.getEvent(m);
        int nn = CbusMessage.getNodeNumber(m);
        CbusTableEvent event = this._model.provideEvent(nn, en);
        event.appendOnOffBean(bean, beanState, CbusEvent.getEvState(m));
        this.fireJmriCellsChanged(this._model.getEventTableRow(nn, en));
    }

    private void fireJmriCellsChanged(int row) {
        ThreadingUtil.runOnGUIEventually(() -> {
            this._model.fireTableCellUpdated(row, 23);
            this._model.fireTableCellUpdated(row, 24);
        });
    }

    private void fireAllJmriCellsChanged() {
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            this.fireJmriCellsChanged(i);
        }
    }

    public void updatejmricols() {
        this._model._mainArray.forEach(n -> n.resetBeans());
        this.fireAllJmriCellsChanged();
        for (Class<?> classType : this.classTypes) {
            Manager sm = (Manager)this._model._memo.get(classType);
            sm.getNamedBeanSet().forEach(nb -> {
                if (nb instanceof CbusEventInterface) {
                    this.linkHwaddtoEvent((NamedBean)nb, true, ((CbusEventInterface)((Object)nb)).getBeanOnMessage());
                    this.linkHwaddtoEvent((NamedBean)nb, false, ((CbusEventInterface)((Object)nb)).getBeanOffMessage());
                }
            });
        }
    }

    public void resetAllSessionTotals() {
        this._model.getEvents().forEach(ev -> {
            ev.resetSessionTotals();
            this.updateStatColumnsinGui(this._model.getEventTableRow(ev.getNn(), ev.getEn()));
        });
    }

    protected final void addRemoveListenersToNbManagers(boolean add) {
        for (Class<?> classType : this.classTypes) {
            if (add) {
                ((Manager)this._model._memo.get(classType)).addPropertyChangeListener(this);
                continue;
            }
            ((Manager)this._model._memo.get(classType)).removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.updatejmricols();
    }

    public void buttonDeleteClicked(int row) {
        if (this.sessionConfirmDeleteRow) {
            ThreadingUtil.runOnGUI(() -> {
                JCheckBox checkbox = new JCheckBox(Bundle.getMessage("PopupSessionConfirmDel"));
                String message = Bundle.getMessage("DelConfirmOne") + "\n" + Bundle.getMessage("DelConfirmTwo");
                Object[] params = new Object[]{message, checkbox};
                if (0 == JmriJOptionPane.showConfirmDialog(null, params, Bundle.getMessage("DelEvPopTitle"), 2, 2)) {
                    this.sessionConfirmDeleteRow = !checkbox.isSelected();
                    this.removeRow(row);
                }
            });
        } else {
            this.removeRow(row);
        }
    }

    protected void removeRow(int row) {
        this._model._mainArray.remove(row);
        ThreadingUtil.runOnGUIEventually(() -> this._model.fireTableRowsDeleted(row, row));
    }

    protected void updateGuiCell(int row, int col) {
        ThreadingUtil.runOnGUIEventually(() -> this._model.fireTableCellUpdated(row, col));
    }

    private void updateStatColumnsinGui(int row) {
        for (int i : CbusEventTableDataModel.canFrameCols) {
            this.updateGuiCell(row, i);
        }
    }

    protected void parseMessage(AbstractMessage m) {
        if (!CbusMessage.isEvent(m)) {
            return;
        }
        CbusTableEvent ev = this._model.provideEvent(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m));
        ev.setState(CbusTableEvent.getEvState(m));
        ev.setCanId(CbusMessage.getId(m));
        ev.setDataFromFrame(m);
        ev.bumpDirection(m instanceof CanReply ? 1 : 2);
        this.updateStatColumnsinGui(this._model.getEventTableRow(CbusMessage.getNodeNumber(m), CbusMessage.getEvent(m)));
    }

    public void dispose() {
        this.addRemoveListenersToNbManagers(false);
    }
}

