/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.eventtable.Bundle;
import jmri.jmrix.can.cbus.eventtable.CbusBasicEventTableModel;
import jmri.jmrix.can.cbus.eventtable.CbusEventBeanData;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableShutdownTask;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableXmlAction;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTableDataModel
extends CbusBasicEventTableModel
implements CanListener,
Disposable {
    private CbusPreferences preferences;
    private ShutDownTask shutDownTask;
    public static final String[] CBUS_EV_TABLE_COL_TOOLTIPS = new String[]{Bundle.getMessage("NodeColTip"), Bundle.getMessage("EventColTip"), Bundle.getMessage("NameColTip"), Bundle.getMessage("CbusNodeNameTip"), Bundle.getMessage("CommentColTip"), Bundle.getMessage("TypeColTip"), Bundle.getMessage("SendToggleTip"), Bundle.getMessage("SendOntip"), Bundle.getMessage("SendOfftip"), Bundle.getMessage("IDColTip"), Bundle.getMessage("ColumnLastHeard"), Bundle.getMessage("ColumnRequestStatusTip"), Bundle.getMessage("ColumnTotalSession"), Bundle.getMessage("ColumnOnSession"), Bundle.getMessage("ColumnOffSession"), Bundle.getMessage("ColumnInSessionTip"), Bundle.getMessage("ColumnOutSessionTip"), null, null, null, null, null, Bundle.getMessage("ColumnEventDeleteTip"), Bundle.getMessage("StlrOnTip"), Bundle.getMessage("StlrOffTip"), null, null, null};
    private static final String[] COLUMN_NAMES = new String[]{"CbusNode", "CbusEvent", "ColumnName", "CbusNodeName", "ColumnComment", "CbusEventOnOrOff", "ColumnToggle", "CbusSendOnHeader", "CbusSendOffHeader", "CanID", "ColumnLastHeard", "ColumnStatusRequest", "ColumnTotalSession", "ColumnOnSession", "ColumnOffSession", "ColumnInSession", "ColumnOutSession", "ColumnTotalAll", "ColumnTotalOn", "ColumnTotalOff", "ColumnTotalIn", "ColumnTotalOut", "ColumnEventDelete", "JmriOnEv", "JmriOffEv", "Dat1", "Dat2", "Dat3"};
    public static final int[] BUTTON_COLUMNS = new int[]{6, 7, 8, 11, 22};
    private static final int[] EDITABLE_COLS = new int[]{2, 4, 6, 7, 8, 11, 22};
    private static final Logger log = LoggerFactory.getLogger(CbusEventTableDataModel.class);

    public CbusEventTableDataModel(CanSystemConnectionMemo memo, int row, int column) {
        this(memo, row);
    }

    public CbusEventTableDataModel(@Nonnull CanSystemConnectionMemo memo, int initialRowSize) {
        super(memo, initialRowSize);
        log.info("Starting {} Event Table", (Object)memo.getProtocol());
        this.preferences = memo.get(CbusPreferences.class);
        this.shutDownTask = new CbusEventTableShutdownTask("CbusEventTableShutdownTask " + memo.getSystemPrefix(), this);
        InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        this.addTc(this._memo);
        this.checkRestoreEvents();
        this.ta.updatejmricols();
    }

    private void checkRestoreEvents() {
        if (this.preferences != null && this.preferences.getSaveRestoreEventTable()) {
            CbusEventTableXmlAction.restoreEventsFromXmlTablestart(this);
        }
    }

    public void skipSaveOnDispose() {
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
    }

    @Override
    public String getColumnName(int col) {
        return Bundle.getMessage(COLUMN_NAMES[col]);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this._mainArray.isEmpty() || null == this.getValueAt(0, col)) {
            return Object.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return Arrays.stream(EDITABLE_COLS).anyMatch(i -> i == col);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 22) {
            ThreadingUtil.runOnGUIEventually(() -> this.ta.buttonDeleteClicked(row));
        } else {
            super.setValueAt(value, row, col);
        }
    }

    @Override
    public void message(CanMessage m) {
        this.ta.parseMessage(m);
    }

    @Override
    public void reply(CanReply m) {
        this.ta.parseMessage(m);
    }

    protected void clearAllEvents() {
        this._mainArray = new ArrayList();
    }

    public CbusEventBeanData getEventBeans(int nn, int en, CbusEventDataElements.EvState state) {
        return this.provideEvent(nn, en).getBeans(state);
    }

    @Override
    public void dispose() {
        this.ta.dispose();
        if (this.preferences != null && this.preferences.getSaveRestoreEventTable()) {
            CbusEventTableXmlAction.storeEventsToXml(this);
        }
        this.removeTc(this._memo);
    }
}

