/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableXmlFile;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTableXmlAction {
    private static final Logger log = LoggerFactory.getLogger(CbusEventTableXmlAction.class);

    protected static SimpleDateFormat getXmlDateStyle() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected static void restoreEventsFromXmlTablestart(CbusEventTableDataModel model) {
        log.debug("restore events from conn {}", (Object)model._memo);
        CbusEventTableXmlFile x = new CbusEventTableXmlFile(model._memo);
        File file = x.getFile(false);
        if (file == null) {
            return;
        }
        try {
            Element root = x.rootFromFile(file);
            root.getChildren("Event").forEach(xmlEvent -> CbusEventTableXmlAction.addSingleEventToModel(xmlEvent, model));
            model.fireTableDataChanged();
            FileUtil.rotate(file, 10, "bup");
        }
        catch (IOException | JDOMException ex) {
            log.error("File Error", ex);
        }
    }

    private static void addSingleEventToModel(Element xmlEvent, CbusEventTableDataModel model) {
        if (xmlEvent.getAttribute("NodeNum") == null || xmlEvent.getAttribute("EventNum") == null) {
            log.error("Node or event number missing in event {}", (Object)xmlEvent.getAttributes());
        } else {
            try {
                CbusTableEvent tabEv = model.provideEvent(Integer.parseInt(xmlEvent.getAttribute("NodeNum").getValue()), Integer.parseInt(xmlEvent.getAttribute("EventNum").getValue()));
                if (xmlEvent.getChild("Name") != null) {
                    tabEv.setName(xmlEvent.getChild("Name").getValue());
                }
                if (xmlEvent.getChild("Comment") != null) {
                    tabEv.setComment(xmlEvent.getChild("Comment").getValue());
                }
                CbusEventTableXmlAction.setEventDate(xmlEvent.getChild("LastHeard"), tabEv);
                tabEv.setCounts(CbusEventTableXmlAction.getChild(xmlEvent, "On"), CbusEventTableXmlAction.getChild(xmlEvent, "Off"), CbusEventTableXmlAction.getChild(xmlEvent, "In"), CbusEventTableXmlAction.getChild(xmlEvent, "Out"));
            }
            catch (NumberFormatException ex) {
                log.error("Incorrect value in event {}", (Object)xmlEvent.getAttributes());
            }
        }
    }

    private static void setEventDate(Element element, CbusTableEvent tabEv) {
        if (element != null) {
            try {
                Date newDate = CbusEventTableXmlAction.getXmlDateStyle().parse(element.getValue());
                tabEv.setDate(newDate);
            }
            catch (ParseException e) {
                log.error("Unable to parse date {}", (Object)element.getValue());
            }
        }
    }

    private static int getChild(Element element, String child) {
        if (element.getChild(child) != null) {
            return Integer.parseInt(element.getChild(child).getValue());
        }
        return 0;
    }

    protected static void storeEventsToXml(CbusEventTableDataModel model) {
        CbusEventTableXmlAction.layoutEventsToXml(model);
    }

    private static void layoutEventsToXml(CbusEventTableDataModel model) {
        log.info("Saving {} CBUS Event xml file.", (Object)model._memo.getUserName());
        CbusEventTableXmlFile x = new CbusEventTableXmlFile(model._memo);
        Element root = new Element("CbusEventDetails");
        root.setAttribute("noNamespaceSchemaLocation", "https://raw.githubusercontent.com/MERG-DEV/JMRI/master/schema/MergCBUSEventTable.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        model.getEvents().forEach(event -> CbusEventTableXmlAction.addSingleEventToXml(event, root));
        try {
            x.writeXML(x.getFile(true), new Document(root));
        }
        catch (IOException ex) {
            log.error("File Error while writing", (Throwable)ex);
        }
    }

    private static void addSingleEventToXml(CbusTableEvent event, Element root) {
        Element values = new Element("Event");
        root.addContent((Content)values);
        values.setAttribute("NodeNum", "" + event.getNn());
        values.setAttribute("EventNum", "" + event.getEn());
        if (!event.getName().isEmpty()) {
            values.addContent((Content)new Element("Name").addContent(event.getName()));
        }
        if (!event.getComment().isEmpty()) {
            values.addContent((Content)new Element("Comment").addContent(event.getComment()));
        }
        if (event.getDate() != null) {
            values.addContent((Content)new Element("LastHeard").addContent(CbusEventTableXmlAction.getXmlDateStyle().format(event.getDate())));
        }
        CbusEventTableXmlAction.addIntContent(event.getTotalOnOff(true), "On", values);
        CbusEventTableXmlAction.addIntContent(event.getTotalOnOff(false), "Off", values);
        CbusEventTableXmlAction.addIntContent(event.getTotalInOut(true), "In", values);
        CbusEventTableXmlAction.addIntContent(event.getTotalInOut(false), "Out", values);
    }

    private static void addIntContent(int val, String name, Element values) {
        if (val > 0) {
            values.addContent((Content)new Element(name).addContent("" + val));
        }
    }
}

