/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import javax.annotation.Nonnull;
import jmri.jmrit.XmlFile;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTableXmlFile
extends XmlFile {
    final CanSystemConnectionMemo memo;
    protected final String oldFileLocation = FileUtil.getUserFilesPath() + "cbus";
    private static final Logger log = LoggerFactory.getLogger(CbusEventTableXmlFile.class);

    public CbusEventTableXmlFile(@Nonnull CanSystemConnectionMemo memo) {
        this.memo = memo;
    }

    public String getDefaultFileName() {
        return this.getFileLocation() + File.separator + this.getFileName();
    }

    public String getFileName() {
        return "EventTableData.xml";
    }

    public File getFile(boolean store) {
        FileUtil.createDirectory(this.getFileLocation());
        this.migrateFileLocation();
        File file = this.findFile(this.getDefaultFileName());
        if (file == null && store) {
            file = new File(this.getDefaultFileName());
        }
        return file;
    }

    public String getFileLocation() {
        return FileUtil.getUserFilesPath() + "cbus" + File.separator + this.memo.getSystemPrefix();
    }

    private void migrateFileLocation() {
        if (this.findFile(this.oldFileLocation + File.separator + this.getFileName()) == null) {
            return;
        }
        try {
            CbusEventTableXmlFile.migrate(Paths.get(this.oldFileLocation, new String[0]), this.getFileLocation(), this.memo.getSystemPrefix());
            log.warn("Migrated existing CBUS Event Table Data to {}", (Object)this.memo.getUserName());
        }
        catch (IOException e) {
            log.error("Unable to migrate CBUS Data ", (Throwable)e);
        }
    }

    public static void migrate(Path fromPath, final String newLocation, String systemPrefix) throws IOException {
        final String oldCbusDirectory = File.separator + "cbus" + File.separator;
        final String newCbusDirectory = oldCbusDirectory + systemPrefix + File.separator;
        Files.walkFileTree(fromPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileString = file.toAbsolutePath().toString();
                if (!fileString.contains(newLocation)) {
                    String newPathString = fileString.replace(oldCbusDirectory, newCbusDirectory);
                    Files.copy(file, Paths.get(newPathString, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

