/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.eventtable;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import jmri.NamedBean;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.eventtable.CbusEventBeanData;

public class CbusTableEvent
extends CbusEvent {
    private int _canid = -1;
    private String _comment;
    private int _sesson;
    private int _toton;
    private int _sessoff;
    private int _totoff;
    private int _sessin;
    private int _totin;
    private int _sessout;
    private int _totout;
    private Set<NamedBean> _nbOnActiveA;
    private Set<NamedBean> _nbOffActiveA;
    private Set<NamedBean> _nbOnActiveB;
    private Set<NamedBean> _nbOffActiveB;
    private Date _timestamp;

    public CbusTableEvent(CanSystemConnectionMemo memo, int nn, int en) {
        super(memo, nn, en);
        this._name = "";
        this._comment = "";
        this._sesson = 0;
        this._sessoff = 0;
        this._sessin = 0;
        this._sessout = 0;
        this._timestamp = null;
        this.resetBeans();
    }

    @Override
    public void setState(CbusEventDataElements.EvState newval) {
        super.setState(newval);
        if (newval == CbusEventDataElements.EvState.ON) {
            ++this._sesson;
            ++this._toton;
            this.setDate(new Date());
        } else if (newval == CbusEventDataElements.EvState.OFF) {
            ++this._sessoff;
            ++this._totoff;
            this.setDate(new Date());
        }
    }

    protected Date getDate() {
        if (this._timestamp != null) {
            return new Date(this._timestamp.getTime());
        }
        return null;
    }

    protected void setDate(Date newval) {
        this._timestamp = newval;
    }

    protected CbusEventBeanData getBeans(CbusEventDataElements.EvState state) {
        return new CbusEventBeanData(this._nbOnActiveA, this._nbOnActiveB, this._nbOffActiveA, this._nbOffActiveB, state);
    }

    protected final void resetBeans() {
        this._nbOnActiveA = new HashSet<NamedBean>();
        this._nbOnActiveB = new HashSet<NamedBean>();
        this._nbOffActiveA = new HashSet<NamedBean>();
        this._nbOffActiveB = new HashSet<NamedBean>();
    }

    public void appendOnOffBean(NamedBean nb, boolean beanState, CbusEventDataElements.EvState evState) {
        if (evState == CbusEventDataElements.EvState.ON) {
            (beanState ? this._nbOnActiveA : this._nbOnActiveB).add(nb);
        } else if (evState == CbusEventDataElements.EvState.OFF) {
            (beanState ? this._nbOffActiveA : this._nbOffActiveB).add(nb);
        }
    }

    protected int getEventCanId() {
        return this._canid;
    }

    public void setComment(String newval) {
        this._comment = newval;
    }

    protected String getComment() {
        return this._comment;
    }

    protected void setCanId(int newval) {
        this._canid = newval;
    }

    protected void setCounts(int on, int off, int in, int out) {
        this._toton = on;
        this._totoff = off;
        this._totin = in;
        this._totout = out;
    }

    protected int getSessionOnOff(boolean on) {
        return on ? this._sesson : this._sessoff;
    }

    protected int getTotalOnOff(boolean on) {
        return on ? this._toton : this._totoff;
    }

    protected int getSessionInOut(boolean in) {
        return in ? this._sessin : this._sessout;
    }

    protected int getTotalInOut(boolean in) {
        return in ? this._totin : this._totout;
    }

    protected void bumpDirection(int direction) {
        if (direction == 1) {
            ++this._sessin;
            ++this._totin;
        } else {
            ++this._sessout;
            ++this._totout;
        }
    }

    protected void resetSessionTotals() {
        this._sesson = 0;
        this._sessoff = 0;
        this._sessin = 0;
        this._sessout = 0;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

