/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.ConditionalNG;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.implementation.AbstractBase;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.logixng.Bundle;
import jmri.jmrix.can.cbus.logixng.CategoryMergCbus;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMergCbusEvent
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectInteger _selectNodeNumber = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectInteger _selectEventNumber = new LogixNG_SelectInteger(this, this);
    private final LogixNG_SelectEnum<CbusEventType> _selectEventType = new LogixNG_SelectEnum((AbstractBase)this, (Enum[])CbusEventType.values(), (Enum)CbusEventType.Off, (PropertyChangeListener)this);
    private CanSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(SendMergCbusEvent.class);

    public SendMergCbusEvent(String sys, String user, CanSystemConnectionMemo memo) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._memo = memo;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        SendMergCbusEvent copy = new SendMergCbusEvent(sysName, userName, this._memo);
        copy.setComment(this.getComment());
        this._selectNodeNumber.copy(copy._selectNodeNumber);
        this._selectEventNumber.copy(copy._selectEventNumber);
        this._selectEventType.copy(copy._selectEventType);
        return manager.registerAction(copy);
    }

    public void setMemo(CanSystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public CanSystemConnectionMemo getMemo() {
        return this._memo;
    }

    public LogixNG_SelectInteger getSelectNodeNumber() {
        return this._selectNodeNumber;
    }

    public LogixNG_SelectInteger getSelectEventNumber() {
        return this._selectEventNumber;
    }

    public LogixNG_SelectEnum<CbusEventType> getSelectEventType() {
        return this._selectEventType;
    }

    @Override
    public Category getCategory() {
        return CategoryMergCbus.CBUS;
    }

    @Override
    public void execute() throws JmriException {
        ConditionalNG conditionalNG = this.getConditionalNG();
        int nodeNumber = this._selectNodeNumber.evaluateValue(conditionalNG);
        int eventNumber = this._selectEventNumber.evaluateValue(conditionalNG);
        CbusEventType state = this._selectEventType.evaluateEnum(this.getConditionalNG());
        ThreadingUtil.runOnLayoutWithJmriException(() -> {
            CbusEvent event = new CbusEvent(this._memo, nodeNumber, eventNumber);
            state._command.action(event);
        });
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "SendCbusEvent_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        String nodeNumber = this._selectNodeNumber.getDescription(locale);
        String eventNumber = this._selectEventNumber.getDescription(locale);
        String eventType = this._selectEventType.getDescription(locale);
        return Bundle.getMessage(locale, "SendCbusEvent_Long", eventNumber, eventType, nodeNumber, this._memo != null ? this._memo.getUserName() : Bundle.getMessage("MemoNotSet"));
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectNodeNumber.registerListeners();
        this._selectEventType.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectNodeNumber.unregisterListeners();
        this._selectEventType.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum CbusEventType {
        Off(e -> e.sendOff(), Bundle.getMessage("SendCbusEvent_EventType_Off")),
        On(e -> e.sendOn(), Bundle.getMessage("SendCbusEvent_EventType_On")),
        Request(e -> e.sendRequest(), Bundle.getMessage("SendCbusEvent_EventType_Request"));

        private final EventCommand _command;
        private final String _text;

        private CbusEventType(EventCommand command, String text) {
            this._command = command;
            this._text = text;
        }

        public String toString() {
            return this._text;
        }

        private static interface EventCommand {
            public void action(CbusEvent var1);
        }
    }
}

