/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.logixng.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectIntegerSwing;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.logixng.CategoryMergCbus;
import jmri.jmrix.can.cbus.logixng.SendMergCbusEvent;
import jmri.jmrix.can.cbus.logixng.swing.Bundle;

public class SendMergCbusEventSwing
extends AbstractDigitalActionSwing {
    private LogixNG_SelectIntegerSwing _selectNodeNumberSwing;
    private LogixNG_SelectIntegerSwing _selectEventNumberSwing;
    private LogixNG_SelectEnumSwing<SendMergCbusEvent.CbusEventType> _selectEventTypeSwing;
    private JComboBox<CbusConnection> _cbusConnection;

    public SendMergCbusEventSwing() {
    }

    public SendMergCbusEventSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        SendMergCbusEvent action = (SendMergCbusEvent)object;
        if (action == null) {
            action = new SendMergCbusEvent("IQDA1", null, null);
        }
        this._selectNodeNumberSwing = new LogixNG_SelectIntegerSwing(this.getJDialog(), this);
        this._selectEventNumberSwing = new LogixNG_SelectIntegerSwing(this.getJDialog(), this);
        this._selectEventTypeSwing = new LogixNG_SelectEnumSwing(this.getJDialog(), this);
        this.panel = new JPanel(new GridBagLayout());
        JPanel tabbedPaneNodeNumber = this._selectNodeNumberSwing.createPanel(action.getSelectNodeNumber());
        JPanel tabbedPaneEventNumber = this._selectEventNumberSwing.createPanel(action.getSelectEventNumber());
        JPanel tabbedPaneCbusEventType = this._selectEventTypeSwing.createPanel(action.getSelectEventType(), SendMergCbusEvent.CbusEventType.values());
        this._cbusConnection = new JComboBox();
        List<CanSystemConnectionMemo> systemConnections = CategoryMergCbus.getMergConnections();
        for (CanSystemConnectionMemo connection : systemConnections) {
            CbusConnection c = new CbusConnection(connection);
            this._cbusConnection.addItem(c);
            if (action.getMemo() != connection) continue;
            this._cbusConnection.setSelectedItem(c);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 13;
        this.panel.add((Component)new JLabel(Bundle.getMessage("SendCbusEventSwing_NodeNumber")), constraints);
        constraints.gridy = 1;
        this.panel.add((Component)new JLabel(Bundle.getMessage("SendCbusEventSwing_EventNumber")), constraints);
        constraints.gridy = 2;
        this.panel.add((Component)new JLabel(Bundle.getMessage("SendCbusEventSwing_EventType")), constraints);
        constraints.gridy = 3;
        this.panel.add((Component)new JLabel(Bundle.getMessage("SendCbusEventSwing_Memo")), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        this.panel.add((Component)tabbedPaneNodeNumber, constraints);
        constraints.gridy = 1;
        this.panel.add((Component)tabbedPaneEventNumber, constraints);
        constraints.gridy = 2;
        this.panel.add((Component)tabbedPaneCbusEventType, constraints);
        constraints.gridy = 3;
        this.panel.add(this._cbusConnection, constraints);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        SendMergCbusEvent action = new SendMergCbusEvent("IQDA1", null, null);
        this._selectNodeNumberSwing.validate(action.getSelectNodeNumber(), errorMessages);
        this._selectEventNumberSwing.validate(action.getSelectEventNumber(), errorMessages);
        this._selectEventTypeSwing.validate(action.getSelectEventType(), errorMessages);
        return errorMessages.isEmpty();
    }

    @Override
    public String getAutoSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getAutoSystemName();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        SendMergCbusEvent action = new SendMergCbusEvent(systemName, userName, null);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof SendMergCbusEvent)) {
            throw new IllegalArgumentException("object must be an SendCbusEvent but is a: " + object.getClass().getName());
        }
        SendMergCbusEvent action = (SendMergCbusEvent)object;
        this._selectNodeNumberSwing.updateObject(action.getSelectNodeNumber());
        this._selectEventNumberSwing.updateObject(action.getSelectEventNumber());
        this._selectEventTypeSwing.updateObject(action.getSelectEventType());
        action.setMemo(this._cbusConnection.getItemAt((int)this._cbusConnection.getSelectedIndex())._memo);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("SendCbusEvent_Short");
    }

    @Override
    public void dispose() {
        this._selectEventTypeSwing.dispose();
        this._selectNodeNumberSwing.dispose();
    }

    private static class CbusConnection {
        private CanSystemConnectionMemo _memo;

        public CbusConnection(CanSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

