/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.CheckForNull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusSend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNode {
    protected CanSystemConnectionMemo _memo;
    private int _nodeNumber;
    private int _canId;
    private boolean _inSetupMode;
    private boolean _inlearnMode;
    private boolean _inFLiMMode;
    public CbusSend send;
    protected final CopyOnWriteArraySet<PropertyChangeListener> _listeners;
    private static final Logger log = LoggerFactory.getLogger(CbusBasicNode.class);

    public CbusBasicNode(@CheckForNull CanSystemConnectionMemo connmemo, int nodenumber) {
        this._memo = connmemo;
        this._nodeNumber = nodenumber;
        this._canId = 1;
        this._inSetupMode = false;
        this._inlearnMode = false;
        this._inFLiMMode = true;
        this.send = new CbusSend(this._memo);
        this._listeners = new CopyOnWriteArraySet();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this._listeners.contains(l)) {
            this._listeners.remove(l);
        }
    }

    protected void notifyPropertyChangeListener(String property, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue) || newValue != null && newValue.equals(oldValue)) {
            log.error("notifyPropertyChangeListener without change");
            return;
        }
        this._listeners.forEach(listener -> listener.propertyChange(new PropertyChangeEvent(this, property, oldValue, newValue)));
    }

    public int getNodeNumber() {
        return this._nodeNumber;
    }

    public void setNodeNumber(int newnumber) {
        this._nodeNumber = newnumber;
        this.notifyPropertyChangeListener("PARAMETER", null, null);
    }

    public final void setCanId(int newcanid) {
        this._canId = newcanid;
        this.notifyPropertyChangeListener("CANID", null, this._canId);
    }

    public final void setCanId(CanSystemConnectionMemo memo) {
        TrafficController tc;
        if (memo != null && (tc = memo.getTrafficController()) != null) {
            this.setCanId(tc.getCanid());
        }
    }

    public int getNodeCanId() {
        return this._canId;
    }

    public void setNodeInSetupMode(boolean setup) {
        this._inSetupMode = setup;
        this.notifyPropertyChangeListener("PARAMETER", null, null);
    }

    public boolean getNodeInSetupMode() {
        return this._inSetupMode;
    }

    public void setNodeInLearnMode(boolean inlearnmode) {
        boolean oldLearnmode = this._inlearnMode;
        this._inlearnMode = inlearnmode;
        if (oldLearnmode != this._inlearnMode) {
            this.notifyPropertyChangeListener("LEARNMODE", oldLearnmode, this._inlearnMode);
        }
    }

    public boolean getNodeInLearnMode() {
        return this._inlearnMode;
    }

    public void setNodeInFLiMMode(boolean inFlimMode) {
        this._inFLiMMode = inFlimMode;
    }

    public boolean getNodeInFLiMMode() {
        return this._inFLiMMode;
    }

    public CanSystemConnectionMemo getMemo() {
        return this._memo;
    }
}

