/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.table.AbstractTableModel;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.tabbedframe.PaneServiceProgFrame;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusConfigurationManager;
import jmri.jmrix.can.cbus.CbusDccProgrammerManager;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBasicNodeTable
extends AbstractTableModel {
    protected ArrayList<CbusNode> _mainArray = new ArrayList();
    protected final CanSystemConnectionMemo _memo;
    protected CbusDccProgrammerManager progMan;
    public static final int NODE_NUMBER_COLUMN = 0;
    public static final int NODE_TYPE_NAME_COLUMN = 1;
    public static final int NODE_USER_NAME_COLUMN = 2;
    public static final int NODE_RESYNC_BUTTON_COLUMN = 3;
    public static final int NODE_EDIT_BUTTON_COLUMN = 4;
    public static final int COMMAND_STAT_NUMBER_COLUMN = 5;
    public static final int CANID_COLUMN = 6;
    public static final int NODE_EVENTS_COLUMN = 7;
    public static final int BYTES_REMAINING_COLUMN = 8;
    public static final int NODE_TOTAL_BYTES_COLUMN = 9;
    public static final int NODE_IN_LEARN_MODE_COLUMN = 10;
    public static final int NODE_EVENT_INDEX_VALID_COLUMN = 11;
    public static final int SESSION_BACKUP_STATUS_COLUMN = 12;
    public static final int NUMBER_BACKUPS_COLUMN = 13;
    public static final int LAST_BACKUP_COLUMN = 14;
    public static final int MAX_COLUMN = 15;
    public static final String[] COLUMNTOOLTIPS = new String[]{null, null, null, null, "Edit Node Variables", null, null, null, null, null, null, "Index invalid when an event addition or deletion has taken place since last fetch.", "Session Backup Status", "Total backups in xml file", null};
    private static final Logger log = LoggerFactory.getLogger(CbusBasicNodeTable.class);

    public CbusBasicNodeTable(@Nonnull CanSystemConnectionMemo memo, int row, int column) {
        this._memo = memo;
        CbusConfigurationManager cfgMan = memo.get(CbusConfigurationManager.class);
        if (cfgMan != null) {
            this.progMan = (CbusDccProgrammerManager)cfgMan.get(GlobalProgrammerManager.class);
            if (this.progMan == null) {
                log.info("No Global Programmer available for NV programming");
            }
        } else {
            log.info("No CbusConfigurationManager available for NV programming");
        }
    }

    @Override
    public int getRowCount() {
        if (this._mainArray == null) {
            log.error("Node Table Array _mainArray not initialised");
            return 0;
        }
        return this._mainArray.size();
    }

    @Override
    public int getColumnCount() {
        return 15;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 6: {
                return Bundle.getMessage("CanID");
            }
            case 0: {
                return Bundle.getMessage("NodeNumberCol");
            }
            case 2: {
                return Bundle.getMessage("UserName");
            }
            case 3: {
                return Bundle.getMessage("ReSynchronizeButton");
            }
            case 4: {
                return Bundle.getMessage("EditButton");
            }
            case 1: {
                return Bundle.getMessage("ColumnType");
            }
            case 5: {
                return Bundle.getMessage("CommandStationNumber");
            }
            case 7: {
                return Bundle.getMessage("CbusEvents");
            }
            case 9: {
                return Bundle.getMessage("TotalBytes");
            }
            case 8: {
                return Bundle.getMessage("FetchProgress");
            }
            case 10: {
                return Bundle.getMessage("LearnMode");
            }
            case 11: {
                return Bundle.getMessage("EventIndexValid");
            }
            case 12: {
                return "Backup Status";
            }
            case 13: {
                return "Num. Backups";
            }
            case 14: {
                return "Last Backup";
            }
        }
        return "unknown " + col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this._mainArray.isEmpty() || this.getValueAt(0, col) == null) {
            return Object.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2 || col == 3 || col == 4;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this._mainArray.get(row).getNodeNumber();
            }
            case 2: {
                return this._mainArray.get(row).getUserName();
            }
            case 1: {
                return this._mainArray.get(row).getNodeStats().getNodeTypeName();
            }
            case 6: {
                return this._mainArray.get(row).getNodeCanId();
            }
            case 5: {
                return this._mainArray.get(row).getCsNum();
            }
            case 7: {
                return this._mainArray.get(row).getNodeEventManager().getTotalNodeEvents();
            }
            case 9: {
                return this._mainArray.get(row).getNodeStats().totalNodeBytes();
            }
            case 8: {
                return Float.valueOf(this._mainArray.get(row).getNodeStats().floatPercentageRemaining());
            }
            case 10: {
                return this._mainArray.get(row).getNodeInLearnMode();
            }
            case 3: {
                return "Re-Sync";
            }
            case 4: {
                return "Edit";
            }
            case 11: {
                return this._mainArray.get(row).getNodeEventManager().isEventIndexValid();
            }
            case 12: {
                return this._mainArray.get(row).getNodeBackupManager().getSessionBackupStatus();
            }
            case 13: {
                return this._mainArray.get(row).getNodeBackupManager().getNumCompleteBackups();
            }
            case 14: {
                return this._mainArray.get(row).getNodeBackupManager().getLastBackupTime();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 2: {
                this._mainArray.get(row).setUserName((String)value);
                ThreadingUtil.runOnGUI(() -> this.fireTableCellUpdated(row, col));
                break;
            }
            case 3: {
                this._mainArray.get(row).saveForResync();
                this._mainArray.get(row).resetNodeAll();
                if (!(this instanceof CbusNodeTableDataModel)) break;
                ((CbusNodeTableDataModel)this).setUrgentNode(this._mainArray.get(row).getNodeNumber());
                ((CbusNodeTableDataModel)this).startBackgroundFetch();
                break;
            }
            case 4: {
                String title = this._mainArray.get(row).getName() + " (CBUS)";
                DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(title);
                String userName = this._mainArray.get(row).getUserName();
                Object nodeNumber = "CBUS_Node_" + Integer.toString(this._mainArray.get(row).getNodeNumber());
                if (!userName.equals("")) {
                    nodeNumber = ((String)nodeNumber).concat("_" + userName);
                }
                if (decoderFile != null && this.progMan != null) {
                    log.debug("decoder file: {}", (Object)decoderFile.getFileName());
                    RosterEntry re = Roster.getDefault().getEntryForId((String)nodeNumber);
                    if (re == null) {
                        re = new RosterEntry(new RosterEntry(), (String)nodeNumber);
                        re.setDecoderFamily("CBUS");
                        re.setMfg(decoderFile.getMfg());
                        re.setDecoderModel(decoderFile.getModel());
                        re.setRoadNumber(Integer.toString(this._mainArray.get(row).getNodeNumber()));
                        re.setRoadName(userName);
                    }
                    String progTitle = "CBUS NV Programmer";
                    String progFile = "programmers" + File.separator + "Cbus.xml";
                    PaneServiceProgFrame p = new PaneServiceProgFrame(decoderFile, re, progTitle, progFile, this.progMan.getGlobalProgrammer());
                    ((Window)p).pack();
                    p.setVisible(true);
                    break;
                }
                log.info("No xml, or no programmer found for node {}", (Object)title);
                JmriJOptionPane.showMessageDialog(null, "<html><h3>No programmer or no decoder file</h3><p>Use Node Variables tab</p></html>", "No xml, or no programmer for " + title, 1);
                break;
            }
            default: {
                log.debug("invalid column");
            }
        }
    }
}

