/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import javax.annotation.CheckForNull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithMgrsCommandStation;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNode
extends CbusBasicNodeWithMgrsCommandStation {
    private int _flags = -1;
    private String _userComment = "";
    private boolean _sendsWRACKonNVSET = true;
    private boolean _nvWriteInLearnOnly = false;
    private boolean _liveUpdate = false;
    public static int SINGLE_MESSAGE_TIMEOUT_TIME = 1500;
    public static int BOOT_PROG_TIMEOUT_FAST = 10;
    public static int BOOT_PROG_TIMEOUT_SLOW = 50;
    public static int BOOT_LONG_TIMEOUT_TIME = 1500;
    private String _nodeNameFromName = "";
    private String resyncName = null;
    private static final Logger log = LoggerFactory.getLogger(CbusNode.class);

    public CbusNode(@CheckForNull CanSystemConnectionMemo connmemo, int nodenumber) {
        super(connmemo, nodenumber);
    }

    public void setNameIfNoName(String newName) {
        if (this.getUserName().isEmpty()) {
            this.setUserName(newName);
        }
    }

    public String getNodeNameFromName() {
        return this._nodeNameFromName;
    }

    public void setNodeNameFromName(String newName) {
        if (newName == null) {
            newName = "";
        }
        this._nodeNameFromName = newName;
        this.notifyPropertyChangeListener("NAMECHANGE", null, null);
    }

    public void setNodeFlags(int flags) {
        this._flags = flags;
        if ((this._flags >> 2 & 1) == 0) {
            this.getNodeBackupManager().setNodeInSlim();
            this.getNodeEventManager().resetNodeEventsToZero();
        }
        if ((this._flags >> 5 & 1) == 1) {
            log.debug("Node in learn mode");
            this.setNodeInLearnMode(true);
        }
        this.notifyPropertyChangeListener("PARAMETER", null, null);
    }

    public int getNodeFlags() {
        return this._flags;
    }

    public String getResyncName() {
        return this.resyncName;
    }

    protected void saveForResync() {
        this.resyncName = !CbusNodeConstants.getModuleType(this.getNodeParamManager().getParameter(1), this.getNodeParamManager().getParameter(3)).isEmpty() ? CbusNodeConstants.getModuleType(this.getNodeParamManager().getParameter(1), this.getNodeParamManager().getParameter(3)) : null;
    }

    protected void resetNodeAll() {
        this.getNodeNvManager().reset();
        this.getNodeEventManager().resetNodeEvents();
        this.getNodeParamManager().clearParameters();
        this.getNodeTimerManager().resetTimeOutCounts();
        this.notifyPropertyChangeListener("PARAMETER", null, null);
    }

    public String getUserComment() {
        return this._userComment;
    }

    public void setUserComment(String comment) {
        this._userComment = comment;
        if (this.getNodeBackupManager().getBackupStarted() && !this.getNodeBackupManager().doStore(false, this.getNodeStats().hasLoadErrors())) {
            log.error("Unable to save User Comment to Node Backup File");
        }
    }

    public String toString() {
        return this.getNodeStats().getNodeNumberName();
    }

    public String getName() {
        return this.getNodeStats().getNodeTypeName();
    }

    protected void nodeOnNetwork(boolean isFound) {
        if (!isFound) {
            this.getNodeTimerManager().cancelTimers();
            this.getNodeParamManager().setParameters(new int[]{0});
            this.getNodeEventManager().resetNodeEventsToZero();
            if (this.getNodeBackupManager().getSessionBackupStatus() != CbusNodeConstants.BackupType.NOTONNETWORK) {
                this.getNodeBackupManager().nodeNotOnNetwork();
            }
            this.notifyPropertyChangeListener("BACKUPS", null, null);
        }
    }

    public void setsendsWRACKonNVSET(Boolean sendsWRACK) {
        this._sendsWRACKonNVSET = sendsWRACK;
    }

    public boolean getsendsWRACKonNVSET() {
        return this._sendsWRACKonNVSET;
    }

    public void setnvWriteInLearnOnly(Boolean nvWriteInLearn) {
        this._nvWriteInLearnOnly = nvWriteInLearn;
    }

    public boolean getnvWriteInLearnOnly() {
        return this._nvWriteInLearnOnly;
    }

    public void setliveUpdate(boolean liveUpdate) {
        this._liveUpdate = liveUpdate;
    }

    public boolean getliveUpdate() {
        return this._liveUpdate;
    }
}

