/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableXmlFile;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeBackupFile
extends XmlFile {
    final CanSystemConnectionMemo memo;
    protected final String oldFileLocation = FileUtil.getUserFilesPath() + "cbus" + File.separator + "nodes";
    private static final Logger log = LoggerFactory.getLogger(CbusNodeBackupFile.class);

    public CbusNodeBackupFile(CanSystemConnectionMemo memo) {
        this.memo = memo;
    }

    private CanSystemConnectionMemo getMemo() {
        return this.memo != null ? this.memo : InstanceManager.getDefault(CanSystemConnectionMemo.class);
    }

    @Nonnull
    public String getDefaultFileName(int nodeNum) {
        return this.getFileLocation() + File.separator + this.getFileName(nodeNum);
    }

    @CheckForNull
    public File getFile(int nodeNum, boolean store) {
        FileUtil.createDirectory(this.getFileLocation());
        this.migrateFileLocation();
        File file = this.findFile(this.getDefaultFileName(nodeNum));
        if (file == null && store) {
            file = new File(this.getDefaultFileName(nodeNum));
        }
        return file;
    }

    public String getFileName(int nodeNum) {
        return nodeNum + ".xml";
    }

    public String getFileLocation() {
        return FileUtil.getUserFilesPath() + "cbus" + File.separator + this.getMemo().getSystemPrefix() + File.separator + "nodes";
    }

    public boolean deleteFile(int nodeNum) {
        File toDelete = this.getFile(nodeNum, false);
        if (toDelete != null) {
            return toDelete.delete();
        }
        return true;
    }

    private void migrateFileLocation() {
        if (this.findFile(this.oldFileLocation) == null) {
            return;
        }
        try {
            CbusEventTableXmlFile.migrate(Paths.get(this.oldFileLocation, new String[0]), this.getFileLocation(), this.getMemo().getSystemPrefix());
            Files.delete(Paths.get(this.oldFileLocation, new String[0]));
            log.warn("Migrated existing CBUS Node Data to {}", (Object)this.getMemo().getUserName());
        }
        catch (IOException e) {
            log.error("Unable to migrate CBUS Data ", (Throwable)e);
        }
    }
}

