/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeBackupFile;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.util.FileUtil;
import jmri.util.LoggingUtil;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeBackupManager {
    public final SimpleDateFormat xmlDateStyle = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int _nodeNum = 0;
    private final CbusBasicNodeWithManagers _node;
    private ArrayList<CbusNodeFromBackup> _backupInfos;
    private boolean backupInit;
    private boolean backupStarted;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeBackupManager.class);

    public CbusNodeBackupManager(CbusBasicNodeWithManagers node) {
        this._nodeNum = node.getNodeNumber();
        this._node = node;
        this._backupInfos = new ArrayList(5);
        this.backupInit = false;
        this.backupStarted = false;
    }

    public ArrayList<CbusNodeFromBackup> getBackups() {
        return this._backupInfos;
    }

    public int getNumCompleteBackups() {
        int i = 0;
        for (int j = 0; j < this._backupInfos.size(); ++j) {
            if (this._backupInfos.get(j).getBackupResult() != CbusNodeConstants.BackupType.COMPLETE) continue;
            ++i;
        }
        return i;
    }

    @CheckForNull
    public Date getFirstBackupTime() {
        for (int j = this._backupInfos.size() - 1; j > -1; --j) {
            if (this._backupInfos.get(j).getBackupResult() != CbusNodeConstants.BackupType.COMPLETE) continue;
            return this._backupInfos.get(j).getBackupTimeStamp();
        }
        return null;
    }

    @CheckForNull
    public Date getLastBackupTime() {
        for (int j = 0; j < this._backupInfos.size(); ++j) {
            if (this._backupInfos.get(j).getBackupResult() != CbusNodeConstants.BackupType.COMPLETE) continue;
            return this._backupInfos.get(j).getBackupTimeStamp();
        }
        return null;
    }

    private int numAutoBackups() {
        int i = 0;
        for (int j = this._backupInfos.size() - 1; j > -1; --j) {
            if (!this._backupInfos.get(j).getBackupComment().isEmpty() || this._backupInfos.get(j).getBackupResult() != CbusNodeConstants.BackupType.COMPLETE) continue;
            ++i;
        }
        return i;
    }

    private void trimBackups() {
        CanSystemConnectionMemo memo = this._node.getMemo();
        CbusPreferences preferences = memo != null ? memo.get(CbusPreferences.class) : InstanceManager.getDefault(CanSystemConnectionMemo.class).get(CbusPreferences.class);
        if (preferences == null) {
            return;
        }
        for (int i = this._backupInfos.size() - 2; i > -1; --i) {
            if (this.numAutoBackups() <= preferences.getMinimumNumBackupsToKeep()) {
                return;
            }
            if (!this._backupInfos.get(i).getBackupComment().isEmpty()) continue;
            this._backupInfos.remove(i);
        }
    }

    public final void doLoad() {
        CbusNodeBackupFile x = new CbusNodeBackupFile(this._node.getMemo());
        if (!(this._node instanceof CbusNode)) {
            return;
        }
        if (this.backupInit) {
            return;
        }
        this.backupInit = true;
        ThreadingUtil.runOnLayout(() -> {
            File file = x.getFile(this._node.getNodeNumber(), true);
            if (file == null) {
                log.debug("No backup file to load");
                return;
            }
            boolean _sortOnLoad = true;
            try {
                Element BackupStatus;
                Element root = x.rootFromFile(file);
                if (root == null) {
                    log.info("File could not be read");
                    return;
                }
                Element details = root.getChild("UserName");
                if (details != null && !details.getValue().isEmpty()) {
                    ((CbusNode)this._node).setUserName(details.getValue());
                }
                if ((details = root.getChild("ModuleTypeName")) != null && !details.getValue().isEmpty()) {
                    ((CbusNode)this._node).setNodeNameFromName(details.getValue());
                }
                if ((details = root.getChild("FreeText")) != null && !details.getValue().isEmpty()) {
                    ((CbusNode)this._node).setUserComment(details.getValue().replaceAll("\\\\n", System.getProperty("line.separator")));
                }
                if ((BackupStatus = root.getChild("Backups")) == null) {
                    log.warn("Unable to find a Previous Layout Backup Entry");
                } else {
                    for (Element info : BackupStatus.getChildren("BackupInfo")) {
                        Element events;
                        Element comment;
                        boolean _backupInfoError = false;
                        CbusNodeFromBackup nodeBackup = new CbusNodeFromBackup(null, this._nodeNum);
                        if (info.getAttributeValue("dateTimeStamp") != null) {
                            try {
                                Date newDate = this.xmlDateStyle.parse(info.getAttributeValue("dateTimeStamp"));
                                nodeBackup.setBackupTimeStamp(newDate);
                            }
                            catch (ParseException e) {
                                log.error("Unable to parse date {}", (Object)info.getAttributeValue("dateTimeStamp"));
                                _sortOnLoad = false;
                                _backupInfoError = true;
                            }
                        } else {
                            log.error("NO datetimestamp in a backup log entry");
                            _sortOnLoad = false;
                            _backupInfoError = true;
                        }
                        if (info.getAttributeValue("result") != null && CbusNodeConstants.lookupByName(info.getAttributeValue("result")) != null) {
                            nodeBackup.setBackupResult(CbusNodeConstants.lookupByName(info.getAttributeValue("result")));
                        } else {
                            log.error("NO result in a backup log entry");
                            _backupInfoError = true;
                            nodeBackup.setBackupResult(CbusNodeConstants.BackupType.INCOMPLETE);
                        }
                        Element params = info.getChild("Parameters");
                        if (params != null && !params.getValue().isEmpty()) {
                            nodeBackup.getNodeParamManager().setParameters(StringUtil.intBytesWithTotalFromNonSpacedHexString(params.getValue(), true));
                        } else {
                            _backupInfoError = true;
                        }
                        Element nvs = info.getChild("NodeVariables");
                        if (nvs != null) {
                            nodeBackup.getNodeNvManager().setNVs(StringUtil.intBytesWithTotalFromNonSpacedHexString(nvs.getValue(), true));
                        }
                        if ((comment = info.getChild("Comment")) != null) {
                            nodeBackup.setBackupComment(comment.getValue());
                        }
                        if ((events = info.getChild("NodeEvents")) != null) {
                            for (Element xmlEvent : events.getChildren("NodeEvent")) {
                                if (xmlEvent.getAttributeValue("NodeNum") != null && xmlEvent.getAttributeValue("EventNum") != null && xmlEvent.getAttributeValue("EvVars") != null) {
                                    if (nodeBackup.getNodeParamManager().getParameter(5) != xmlEvent.getAttributeValue("EvVars").length() / 2) {
                                        LoggingUtil.warnOnce(log, "Incorrect Event Variable Length in Backup for Node {}", nodeBackup.getNodeNumber());
                                        _backupInfoError = true;
                                    }
                                    try {
                                        nodeBackup.addBupEvent(Integer.parseInt(xmlEvent.getAttributeValue("NodeNum")), Integer.parseInt(xmlEvent.getAttributeValue("EventNum")), xmlEvent.getAttributeValue("EvVars"));
                                    }
                                    catch (NumberFormatException ex) {
                                        LoggingUtil.warnOnce(log, "Incorrect Node / Event Number in Backup for Node {}", nodeBackup.getNodeNumber());
                                        _backupInfoError = true;
                                    }
                                    continue;
                                }
                                log.error("Node / Event Number Missing in Backup");
                                _backupInfoError = true;
                            }
                        }
                        if (_backupInfoError && nodeBackup.getBackupResult() == CbusNodeConstants.BackupType.COMPLETE) {
                            nodeBackup.setBackupResult(CbusNodeConstants.BackupType.INCOMPLETE);
                        }
                        this._backupInfos.add(nodeBackup);
                    }
                }
            }
            catch (JDOMException ex) {
                log.error("File invalid: {}", (Object)file.getName(), (Object)ex);
                return;
            }
            catch (IOException ex) {
                log.debug("Possible Error reading file: ", (Throwable)ex);
                return;
            }
            if (_sortOnLoad) {
                Collections.sort(this._backupInfos, Collections.reverseOrder());
            }
            this._node.notifyPropertyChangeListener("BACKUPS", null, null);
        });
    }

    public boolean doStore(boolean createNew, boolean seenErrors) {
        if (!(this._node instanceof CbusNode)) {
            return false;
        }
        this.setBackupStarted(true);
        Date thisBackupDate = new Date();
        CbusNodeBackupFile x = new CbusNodeBackupFile(this._node.getMemo());
        File file = x.getFile(this._node.getNodeNumber(), true);
        if (file == null) {
            log.error("Unable to get backup file prior to save");
            return false;
        }
        this.doRotate();
        if (createNew) {
            this._backupInfos.add(0, new CbusNodeFromBackup((CbusNode)this._node, thisBackupDate));
            if (seenErrors) {
                this._backupInfos.get(0).setBackupResult(CbusNodeConstants.BackupType.COMPLETEDWITHERROR);
            }
        }
        this.trimBackups();
        Element root = new Element("CbusNode");
        root.setAttribute("noNamespaceSchemaLocation", "https://raw.githubusercontent.com/MERG-DEV/JMRI/master/schema/MergCBUSNodeBackup.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        root.setAttribute("NodeNum", "" + this._node.getNodeNumber());
        if (!((CbusNode)this._node).getUserName().isEmpty()) {
            root.addContent((Content)new Element("UserName").addContent(((CbusNode)this._node).getUserName()));
        }
        if (!((CbusNode)this._node).getNodeNameFromName().isEmpty()) {
            root.addContent((Content)new Element("ModuleTypeName").addContent(((CbusNode)this._node).getNodeNameFromName()));
        }
        if (!((CbusNode)this._node).getUserComment().isEmpty()) {
            root.addContent((Content)new Element("FreeText").addContent(((CbusNode)this._node).getUserComment().replaceAll("\r\n|\n|\r", "\\\\n")));
        }
        Document doc = new Document(root);
        Element values = new Element("Backups");
        root.addContent((Content)values);
        this._backupInfos.stream().map(node -> {
            Element e = new Element("BackupInfo");
            e.setAttribute("dateTimeStamp", this.xmlDateStyle.format(node.getBackupTimeStamp()));
            e.setAttribute("result", "" + node.getBackupResult());
            if (!node.getBackupComment().isEmpty()) {
                e.addContent((Content)new Element("Comment").addContent(node.getBackupComment()));
            }
            if (!node.getNodeParamManager().getParameterHexString().isEmpty()) {
                e.addContent((Content)new Element("Parameters").addContent(node.getNodeParamManager().getParameterHexString()));
            }
            if (!node.getNodeNvManager().getNvHexString().isEmpty()) {
                e.addContent((Content)new Element("NodeVariables").addContent(node.getNodeNvManager().getNvHexString()));
            }
            if (node.getNodeEventManager().getTotalNodeEvents() > 0) {
                Element bupev = new Element("NodeEvents");
                ArrayList<CbusNodeEvent> _tmpArr = node.getNodeEventManager().getEventArray();
                if (_tmpArr != null) {
                    _tmpArr.forEach(bupndev -> {
                        Element ndev = new Element("NodeEvent");
                        ndev.setAttribute("NodeNum", "" + bupndev.getNn());
                        ndev.setAttribute("EventNum", "" + bupndev.getEn());
                        ndev.setAttribute("EvVars", bupndev.getHexEvVarString());
                        bupev.addContent((Content)ndev);
                    });
                    e.addContent((Content)bupev);
                }
            }
            return e;
        }).forEachOrdered(e -> values.addContent((Content)e));
        try {
            x.writeXML(file, doc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing: ", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("IO Exception when writing: ", (Throwable)ex);
            return false;
        }
        log.debug("...done");
        this._node.notifyPropertyChangeListener("BACKUPS", null, null);
        return true;
    }

    protected void nodeNotOnNetwork() {
        if (this._node instanceof CbusNode) {
            CbusNodeFromBackup newBup = new CbusNodeFromBackup((CbusNode)this._node, new Date());
            newBup.setBackupResult(CbusNodeConstants.BackupType.NOTONNETWORK);
            this._backupInfos.add(0, newBup);
            this.doStore(false, false);
        }
    }

    protected void nodeInSLiM() {
        if (this._node instanceof CbusNode) {
            CbusNodeFromBackup newBup = new CbusNodeFromBackup((CbusNode)this._node, new Date());
            newBup.setBackupResult(CbusNodeConstants.BackupType.SLIM);
            this._backupInfos.add(0, newBup);
            this.doStore(false, false);
        }
    }

    protected boolean removeNode(boolean rotate) {
        CbusNodeBackupFile x = new CbusNodeBackupFile(this._node.getMemo());
        if (rotate) {
            this.doRotate();
        }
        if (!x.deleteFile(this._node.getNodeNumber())) {
            log.error("Unable to delete node xml file");
            return false;
        }
        return true;
    }

    private void doRotate() {
        CbusNodeBackupFile x = new CbusNodeBackupFile(this._node.getMemo());
        File file = x.getFile(this._node.getNodeNumber(), false);
        if (file == null) {
            return;
        }
        try {
            Element roots = x.rootFromFile(file);
            if (roots == null) {
                return;
            }
            FileUtil.rotate(file, 5, "bup");
        }
        catch (IOException ex) {
            log.debug("Backup Rotate failed {}", (Object)file);
        }
        catch (JDOMException ex) {
            log.debug("File invalid: {}", (Object)file);
        }
    }

    protected File getFileLocation() {
        return new CbusNodeBackupFile(this._node.getMemo()).getFile(this._node.getNodeNumber(), true);
    }

    protected void resetBupArray() {
        this._backupInfos = new ArrayList(5);
        this.backupInit = false;
    }

    @Nonnull
    public CbusNodeConstants.BackupType getSessionBackupStatus() {
        if (this.backupStarted && !this.getBackups().isEmpty()) {
            return this.getBackups().get(0).getBackupResult();
        }
        return CbusNodeConstants.BackupType.OUTSTANDING;
    }

    protected void setBackupStarted(boolean started) {
        this.backupStarted = started;
    }

    protected boolean getBackupStarted() {
        return this.backupStarted;
    }

    protected void setNodeInSlim() {
        log.info("Node {} in SLiM mode", (Object)this._node);
        if (this.getBackupStarted()) {
            this.doLoad();
            this.nodeInSLiM();
        }
    }
}

