/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.Arrays;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeCanListener
implements CanListener {
    public final CanSystemConnectionMemo memo;
    private final CbusBasicNodeWithManagers _node;
    private int[] tempSetupParams;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeCanListener.class);

    public CbusNodeCanListener(CanSystemConnectionMemo connmemo, CbusBasicNodeWithManagers node) {
        this.memo = connmemo;
        this._node = node;
        this.addTc(this.memo);
    }

    @Override
    public void message(CanMessage m) {
        switch (CbusMessage.getOpcode(m)) {
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 93: 
            case 117: 
            case 149: 
            case 150: 
            case 210: {
                CanReply r = new CanReply(m);
                this.reply(r);
                break;
            }
        }
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = CbusMessage.getOpcode(m);
        int nn = m.getElement(1) * 256 + m.getElement(2);
        if (this._node.getNodeInLearnMode()) {
            this.processInLearnMode(m);
        }
        if (nn != this._node.getNodeNumber()) {
            return;
        }
        this._node.setCanId(CbusMessage.getId(m));
        switch (CbusMessage.getOpcode(m)) {
            case 111: {
                if (m.getElement(3) == 5) {
                    this._node.getNodeEventManager().remainingEvVarsNotNeeded();
                    break;
                }
                if (m.getElement(3) > 0 && m.getElement(3) < 13) {
                    log.error("Node {} reporting {}", (Object)this._node, (Object)Bundle.getMessage("CMDERR" + m.getElement(3)));
                    break;
                }
                log.error("Node {} Reporting Error Code {} (decimal)", (Object)this._node, (Object)m.getElement(3));
                break;
            }
            case 82: {
                if (this._node.getNodeTimerManager().sendEnumTask == null) break;
                this._node.getNodeTimerManager().clearSendEnumTimeout();
                break;
            }
            case 155: {
                this.processParam(m);
                break;
            }
            case 116: {
                int newEventsOnNode = m.getElement(3);
                this._node.getNodeTimerManager().clearNumEvTimeout();
                this._node.getNodeEventManager().resetNodeEventsToZero();
                if (this._node.getNodeParamManager().getParameter(5) < 0) {
                    return;
                }
                for (int i = 0; i < newEventsOnNode; ++i) {
                    CbusNodeEvent newev = new CbusNodeEvent(this.memo, -1, -1, this._node.getNodeNumber(), -1, this._node.getNodeParamManager().getParameter(5));
                    this._node.getNodeEventManager().addNewEvent(newev);
                }
                this._node.notifyPropertyChangeListener("ALLEVUPDATE", null, null);
                break;
            }
            case 242: {
                int evnode = m.getElement(3) * 256 + m.getElement(4);
                int evev = m.getElement(5) * 256 + m.getElement(6);
                this._node.getNodeEventManager().setNextEmptyNodeEvent(evnode, evev, m.getElement(7));
                if (this._node.getNodeTimerManager().allEvTimerTask == null || this._node.getNodeEventManager().getOutstandingIndexNodeEvents() != 0) break;
                this._node.getNodeTimerManager().clearAllEvTimeout();
                this._node.getNodeEventManager().setEvIndexValid(true);
                break;
            }
            case 181: {
                this._node.getNodeTimerManager().clearNextEvVarTimeout();
                this._node.getNodeEventManager().setEvVarByIndex(m.getElement(3), m.getElement(4), m.getElement(5));
                break;
            }
            case 151: {
                this._node.getNodeTimerManager().clearNextNvVarTimeout();
                this._node.getNodeNvManager().setNV(m.getElement(3), m.getElement(4));
                break;
            }
            case 150: {
                this._node.getNodeNvManager().setNV(m.getElement(3), m.getElement(4));
                break;
            }
            case 83: {
                if (((CbusNode)this._node).getnvWriteInLearnOnly()) break;
                this._node.setNodeInLearnMode(true);
                break;
            }
            case 84: {
                this._node.setNodeInLearnMode(false);
                break;
            }
            case 93: {
                this._node.setCanId(-1);
                this._node.getNodeTimerManager().setsendEnumTimeout();
                break;
            }
            case 117: {
                this._node.setCanId(-1);
                break;
            }
        }
        if (this._node.getNodeNvManager().teachOutstandingNvs()) {
            if (opc == 89) {
                this._node.getNodeTimerManager().clearsendEditNvTimeout();
                this._node.getNodeNvManager().sendNextNvToNode();
            } else if (opc == 111) {
                ++this._node.getNodeTimerManager()._sendNVErrorCount;
                log.warn("Node reports NV Write Error");
                this._node.getNodeTimerManager().clearsendEditNvTimeout();
                this._node.getNodeNvManager().sendNextNvToNode();
            }
        }
        if (this._node.getTableModel() != null) {
            this._node.getTableModel().triggerUrgentFetch();
        }
    }

    private void processParam(CanReply m) {
        this._node.getNodeTimerManager().clearAllParamTimeout();
        if (m.getElement(3) == 0) {
            int[] myarray = new int[m.getElement(4) + 1];
            Arrays.fill(myarray, -1);
            myarray[1] = this._node.getPnnManufacturer();
            myarray[2] = this._node._fwMin;
            myarray[3] = this._node.getPnnModule();
            myarray[7] = this._node._fwMaj;
            if (this.tempSetupParams != null) {
                log.debug("tempSetupParams {}", (Object)this.tempSetupParams);
                myarray[1] = this.tempSetupParams[0];
                myarray[2] = this.tempSetupParams[1];
                myarray[3] = this.tempSetupParams[2];
                myarray[4] = this.tempSetupParams[3];
                myarray[5] = this.tempSetupParams[4];
                myarray[6] = this.tempSetupParams[5];
                myarray[7] = this.tempSetupParams[6];
                if (myarray[6] > -1) {
                    int[] myParray = new int[myarray[6] + 1];
                    Arrays.fill(myParray, -1);
                    myParray[0] = myarray[6];
                    this._node.getNodeNvManager().setNVs(myParray);
                }
            }
            myarray[0] = m.getElement(4);
            this._node.getNodeParamManager().setParameters(myarray);
            this._node.getNodeParamManager().setParameter(20, this._node._fwBuild);
        } else {
            this._node.getNodeParamManager().setParameter(m.getElement(3), m.getElement(4));
            if (m.getElement(3) == 6) {
                int[] myarray = new int[m.getElement(4) + 1];
                Arrays.fill(myarray, -1);
                myarray[0] = m.getElement(4);
                this._node.getNodeNvManager().setNVs(myarray);
            }
        }
    }

    private void processInLearnMode(CanReply m) {
        int opc = CbusMessage.getOpcode(m);
        int nn = m.getElement(1) * 256 + m.getElement(2);
        switch (opc) {
            case 85: {
                if (nn != this._node.getNodeNumber()) break;
                this._node.getNodeEventManager().resetNodeEventsToZero();
                break;
            }
            case 210: {
                this._node.getNodeEventManager().updateNodeFromLearn(nn, m.getElement(3) * 256 + m.getElement(4), m.getElement(5), m.getElement(6));
                break;
            }
            case 149: {
                this._node.getNodeEventManager().removeEvent(m.getElement(1) * 256 + m.getElement(2), m.getElement(3) * 256 + m.getElement(4));
                break;
            }
            case 245: {
                this.processEvlrni(m);
                break;
            }
        }
        if (this._node.getNodeEventManager().TEACH_OUTSTANDING_EVS) {
            if (opc == 89) {
                this._node.getNodeTimerManager().clearsendEditEvTimeout();
                this._node.getNodeEventManager().teachNewEvLoop();
            }
            if (opc == 111) {
                this._node.getNodeTimerManager().clearsendEditEvTimeout();
                ++this._node.getNodeTimerManager().sendEvErrorCount;
                this._node.getNodeEventManager().teachNewEvLoop();
            }
        }
    }

    private void processEvlrni(CanReply m) {
        if (!this._node.getNodeEventManager().isEventIndexValid()) {
            log.warn("EVRLNI OPC heard while Event Index Invalid for Node {}", (Object)this._node);
        } else {
            CbusNodeEvent toEdit = this._node.getNodeEventManager().getNodeEventByIndex(m.getElement(5));
            if (toEdit == null) {
                log.warn("No event with index {} found on node {}", (Object)m.getElement(5), (Object)this.toString());
            } else {
                toEdit.setNn(m.getElement(1) * 256 + m.getElement(2));
                toEdit.setEn(m.getElement(3) * 256 + m.getElement(4));
                toEdit.setEvVar(m.getElement(6) * 256, m.getElement(7));
            }
        }
    }

    public void setParamsFromSetup(int[] setupParams) {
        log.debug("setup parameters received {}", (Object)setupParams);
        this.tempSetupParams = setupParams;
    }

    public void dispose() {
        this.removeTc(this.memo);
    }
}

