/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.ArrayList;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusBasicNodeTableOperations;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;

public class CbusNodeFromFcuTableDataModel
extends CbusBasicNodeTableOperations {
    public static final int FCU_NODE_NUMBER_COLUMN = 0;
    public static final int FCU_NODE_TYPE_NAME_COLUMN = 1;
    public static final int FCU_NODE_USER_NAME_COLUMN = 2;
    public static final int FCU_NODE_EVENTS_COLUMN = 3;
    public static final int NODE_NV_TOTAL_COLUMN = 4;
    public static final int FCU_NODE_TOTAL_BYTES_COLUMN = 5;
    public static final int FCU_MAX_COLUMN = 6;
    public static final String[] FCUTABLETIPS = new String[]{null, null, null, null, null, null, null, null, null, null};

    public CbusNodeFromFcuTableDataModel(CanSystemConnectionMemo memo, int row, int column) {
        super(memo, row, column);
        this._mainArray = new ArrayList();
    }

    @Override
    public int getRowCount() {
        return this._mainArray.size();
    }

    public void resetData() {
        this._mainArray.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("NodeNumberCol");
            }
            case 2: {
                return Bundle.getMessage("UserName");
            }
            case 1: {
                return Bundle.getMessage("ColumnType");
            }
            case 3: {
                return Bundle.getMessage("CbusEvents");
            }
            case 4: {
                return Bundle.getMessage("ColumnNVs");
            }
            case 5: {
                return Bundle.getMessage("TotalBytes");
            }
        }
        return "unknown " + col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (this._mainArray.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, col).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return ((CbusNode)this._mainArray.get(row)).getNodeNumber();
            }
            case 2: {
                return ((CbusNode)this._mainArray.get(row)).getUserName();
            }
            case 1: {
                return ((CbusNode)this._mainArray.get(row)).getNodeStats().getNodeTypeName();
            }
            case 3: {
                return ((CbusNode)this._mainArray.get(row)).getNodeEventManager().getTotalNodeEvents();
            }
            case 4: {
                return ((CbusNode)this._mainArray.get(row)).getNodeNvManager().getTotalNVs();
            }
            case 5: {
                return ((CbusNode)this._mainArray.get(row)).getNodeStats().totalNodeBytes();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public CbusNodeFromBackup provideNodeByNodeNum(int nodenum) {
        if (nodenum < 1 || nodenum > 65535) {
            throw new IllegalArgumentException("Node number should be between 1 and 65535");
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((CbusNode)this._mainArray.get(i)).getNodeNumber() != nodenum) continue;
            return (CbusNodeFromBackup)this._mainArray.get(i);
        }
        CbusNodeFromBackup cs = new CbusNodeFromBackup(this._memo, nodenum);
        this.addNode(cs);
        return cs;
    }
}

