/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.Arrays;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.Bundle;
import jmri.jmrix.can.cbus.node.CbusBasicNodeWithManagers;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeNVManager {
    private final CbusBasicNodeWithManagers _node;
    private int[] _nvArray;
    private int[] newNvsToTeach;
    private int nextNvInLoop;
    private boolean TEACH_OUTSTANDING_NVS = false;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeNVManager.class);

    public CbusNodeNVManager(CbusBasicNodeWithManagers node) {
        this._node = node;
    }

    protected void reset() {
        this._nvArray = null;
        this._node.getNodeTimerManager()._sendNVErrorCount = 0;
    }

    protected boolean teachOutstandingNvs() {
        return this.TEACH_OUTSTANDING_NVS;
    }

    public void setNVs(@Nonnull int[] newnvs) {
        this._nvArray = new int[newnvs.length];
        for (int i = 0; i < newnvs.length; ++i) {
            this.setNV(i, newnvs[i]);
        }
        this._node.notifyPropertyChangeListener("ALLNVUPDATE", null, null);
    }

    public void setNV(int index, int newnv) {
        if (this._nvArray == null) {
            log.error("Attempted to set NV {} on a null NV Array on Node {}", (Object)index, (Object)this._node);
            return;
        }
        if (index == 0 && newnv != this._node.getNodeParamManager().getParameter(6) && this._node.getNodeParamManager().getParameter(6) != -1) {
            log.error("Node {} NV Count mismatch. Parameters report {} NVs, received set for {} NVs", new Object[]{this._node, this._node.getNodeParamManager().getParameter(6), newnv});
        }
        if (index < 0 || index > 255) {
            log.error("Attempted to set Invalid NV {} on Node {}", (Object)index, (Object)this._node);
            return;
        }
        if (newnv < -1 || newnv > 255) {
            log.error("Attempted to set NV {} Invalid Value {} on Node {}", new Object[]{index, newnv, this._node});
            return;
        }
        this._nvArray[index] = newnv;
        if (index > 0) {
            this._node.notifyPropertyChangeListener("SINGLENVUPDATE", null, index - 1);
        }
    }

    public int[] getNvArray() {
        return this._nvArray;
    }

    public int getTotalNVs() {
        if (this._nvArray == null) {
            return 0;
        }
        return this._nvArray[0];
    }

    public int getNV(int index) {
        if (this.getTotalNVs() < 1) {
            return -1;
        }
        return this._nvArray[index];
    }

    public int getNvDifference(CbusNode testAgainst) {
        int count = 0;
        for (int i = 0; i < this._nvArray.length; ++i) {
            if (this.getNV(i) == testAgainst.getNodeNvManager().getNV(i)) continue;
            ++count;
        }
        return count;
    }

    public int getOutstandingNvCount() {
        int count = 0;
        if (this._nvArray == null) {
            return -1;
        }
        for (int i = 0; i < this._nvArray.length; ++i) {
            if (this._nvArray[i] >= 0) continue;
            ++count;
        }
        return count;
    }

    protected void sendNextNVToFetch() {
        if (this._node.getNodeTimerManager().hasActiveTimers()) {
            return;
        }
        for (int i = 0; i < this._nvArray.length; ++i) {
            if (this._nvArray[i] >= 0) continue;
            this._node.getNodeTimerManager().setNextNvVarTimeout();
            this._node.send.nVRD(this._node.getNodeNumber(), i);
            return;
        }
    }

    public void sendNvsToNode(int[] newnv) {
        this.newNvsToTeach = newnv;
        this.nextNvInLoop = 1;
        this.TEACH_OUTSTANDING_NVS = true;
        this._node.getNodeTimerManager()._sendNVErrorCount = 0;
        this.sendNextNvToNode();
    }

    protected void sendNextNvToNode() {
        if (this._node.getNodeTimerManager().hasActiveTimers()) {
            return;
        }
        for (int i = this.nextNvInLoop; i < this._nvArray.length; ++i) {
            if (this.newNvsToTeach[i] == this._nvArray[i]) continue;
            this._node.getNodeTimerManager().setsendEditNvTimeout();
            this._node.send.nVSET(this._node.getNodeNumber(), i, this.newNvsToTeach[i]);
            this.nextNvInLoop = i;
            return;
        }
        log.info("TEACH NV COMPLETE {}", (Object)Bundle.getMessage("NdCompleteNVar", String.valueOf(this._node.getNodeTimerManager()._sendNVErrorCount), this._node));
        this.TEACH_OUTSTANDING_NVS = false;
        this._node.notifyPropertyChangeListener("TEACHNVCOMPLETE", null, this._node.getNodeTimerManager()._sendNVErrorCount);
        if (this._node.getNodeTimerManager()._sendNVErrorCount > 0) {
            int[] myarray = new int[this._node.getNodeParamManager().getParameter(6) + 1];
            Arrays.fill(myarray, -1);
            myarray[0] = this._node.getNodeParamManager().getParameter(6);
            this.setNVs(myarray);
            this._node.getTableModel().startUrgentFetch();
        }
        this._node.getNodeTimerManager()._sendNVErrorCount = 0;
    }

    public String getNvHexString() {
        if (this.getNvArray() == null) {
            return "";
        }
        return StringUtil.hexStringFromInts(this.getNvArray()).replaceAll("\\s", "").substring(2);
    }

    public String toString() {
        return "Node Variables";
    }
}

