/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.node;

import java.util.TimerTask;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.node.CbusBasicNodeTableFetch;
import jmri.util.TimerUtil;

public class CbusNodeTrickleFetch
implements CanListener {
    private final CbusBasicNodeTableFetch nodeModel;
    private final TrafficController tc;
    private TimerTask trickleTimer;
    private final long trickleTimeoutValue;
    private boolean networkActive;

    public CbusNodeTrickleFetch(CanSystemConnectionMemo memo, CbusBasicNodeTableFetch model, long timeoutValue) {
        this.nodeModel = model;
        this.trickleTimeoutValue = timeoutValue;
        this.tc = memo.getTrafficController();
        this.networkActive = false;
        if (timeoutValue > 0L) {
            this.addTc(this.tc);
            this.startTrickleTimer();
        }
    }

    private void startTrickleTimer() {
        if (this.trickleTimer == null) {
            this.trickleTimer = new TimerTask(){

                @Override
                public void run() {
                    CbusNodeTrickleFetch.this.seeIfCanBusy();
                }
            };
        }
        TimerUtil.schedule(this.trickleTimer, this.trickleTimeoutValue, this.trickleTimeoutValue);
    }

    private void stopTrickleTimer() {
        if (this.trickleTimer != null) {
            this.trickleTimer.cancel();
            this.trickleTimer = null;
        }
    }

    private void seeIfCanBusy() {
        if (!this.networkActive) {
            this.nodeModel.sendNextBackgroundFetch();
        } else {
            this.networkActive = false;
        }
    }

    @Override
    public void message(CanMessage m) {
        this.networkActive = true;
    }

    @Override
    public void reply(CanReply m) {
        this.networkActive = true;
    }

    public void dispose() {
        this.stopTrickleTimer();
        this.removeTc(this.tc);
    }
}

