/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.simulator.CbusDummyCS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusDummyCSSession {
    private CbusDummyCS _cs;
    private int _sessionID;
    private int _Addr;
    private Boolean _isLong;
    private int _speedDirection;
    private int _fa;
    private int _fb;
    private int _fc;
    private Timer _RefreshTimer;
    private Boolean _dispatched;
    private static final Logger log = LoggerFactory.getLogger(CbusDummyCSSession.class);

    public CbusDummyCSSession(CbusDummyCS cs, int sessionID, int rcvdIntAddr, Boolean rcvdIsLong) {
        this._cs = cs;
        this._sessionID = sessionID;
        this._Addr = rcvdIntAddr;
        this._isLong = rcvdIsLong;
        this.init();
    }

    private void init() {
        this._speedDirection = CbusDummyCS.DEFAULT_SESSION_START_SPDDIR;
        this._fa = 0;
        this._fb = 0;
        this._fc = 0;
        this._dispatched = false;
        this._RefreshTimer = new Timer(CbusDummyCS.DEFAULT_CS_TIMEOUT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CbusDummyCSSession.this.csSessionTimeout();
            }
        });
        this._RefreshTimer.setRepeats(false);
        this._RefreshTimer.start();
    }

    protected void dispose() {
        this._RefreshTimer.stop();
        this._RefreshTimer = null;
    }

    private void csSessionTimeout() {
        log.info("Session {} Timeout", (Object)this._sessionID);
        if (this._cs.getDummyType() == 1) {
            this._cs.destroySession(this);
        }
    }

    protected void keepAlive() {
        this._RefreshTimer.restart();
    }

    protected void sendPloc() {
        int locoaddr = this._Addr;
        if (this._isLong.booleanValue()) {
            locoaddr |= 0xC000;
        }
        CanReply r = new CanReply(7);
        r.setElement(0, 225);
        r.setElement(1, this._sessionID);
        r.setElement(2, locoaddr / 256);
        r.setElement(3, locoaddr & 0xFF);
        r.setElement(4, this._speedDirection);
        r.setElement(5, this._fa);
        r.setElement(6, this._fb);
        r.setElement(7, this._fc);
        this._cs.send.sendWithDelay(r, this._cs.getSendIn(), this._cs.getSendOut(), this._cs.getDelay());
    }

    protected int getSessionNum() {
        return this._sessionID;
    }

    protected int getrcvdIntAddr() {
        return this._Addr;
    }

    protected Boolean getisLong() {
        return this._isLong;
    }

    protected void setSpd(int speeddir) {
        this._speedDirection = speeddir;
        this._RefreshTimer.restart();
    }

    protected Boolean getIsDispatched() {
        return this._dispatched;
    }
}

