/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import javax.annotation.CheckForNull;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeCanListener;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.simulator.CbusDummyNodeCanListener;
import jmri.jmrix.can.cbus.swing.simulator.NdPane;

public class CbusDummyNode
extends CbusNode {
    private NdPane _pane;
    private CbusDummyNodeCanListener canListener;

    public CbusDummyNode(@CheckForNull CanSystemConnectionMemo sysmemo, int nodenumber) {
        super(sysmemo, nodenumber);
        super.setNodeInFLiMMode(false);
        this.setCanId(sysmemo);
        this._pane = null;
    }

    @Override
    public CbusNodeCanListener getNewCanListener() {
        this.canListener = new CbusDummyNodeCanListener(this._memo, this);
        return this.canListener;
    }

    protected void sendNUMEV() {
        CanReply r = new CanReply(4);
        r.setElement(0, 116);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, Math.max(0, this.getNodeEventManager().getTotalNodeEvents()) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendENRSP() {
        CbusNodeEvent ndEv;
        int extraDelay = 5;
        for (int i = 0; i < this.getNodeEventManager().getTotalNodeEvents() && (ndEv = this.getNodeEventManager().getNodeEventByArrayID(i)) != null; ++i) {
            if (ndEv.getIndex() < 0) {
                ndEv.setIndex(this.getNodeEventManager().getNextFreeIndex());
            }
            CanReply r = new CanReply(8);
            r.setElement(0, 242);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, ndEv.getNn() >> 8);
            r.setElement(4, ndEv.getNn() & 0xFF);
            r.setElement(5, ndEv.getEn() >> 8);
            r.setElement(6, ndEv.getEn() & 0xFF);
            r.setElement(7, ndEv.getIndex() & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay() + extraDelay * i);
        }
    }

    protected void sendNEVAL(int index, int varIndex) {
        CbusNodeEvent _ndEv = this.getNodeEventManager().getNodeEventByIndex(index);
        if (index < 0 || index > 255) {
            this.sendCMDERR(7);
        } else if (_ndEv == null) {
            this.sendCMDERR(12);
        } else {
            CanReply r = new CanReply(6);
            r.setElement(0, 181);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, varIndex & 0xFF);
            r.setElement(5, _ndEv.getEvVar(varIndex) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
    }

    protected void sendPARAMS() {
        CanReply r = new CanReply(8);
        r.setElement(0, 239);
        r.setElement(1, this.getNodeParamManager().getParameter(1) & 0xFF);
        r.setElement(2, this.getNodeParamManager().getParameter(2) & 0xFF);
        r.setElement(3, this.getNodeParamManager().getParameter(3) & 0xFF);
        r.setElement(4, this.getNodeParamManager().getParameter(4) & 0xFF);
        r.setElement(5, this.getNodeParamManager().getParameter(5) & 0xFF);
        r.setElement(6, this.getNodeParamManager().getParameter(6) & 0xFF);
        r.setElement(7, this.getNodeParamManager().getParameter(7) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendPNN() {
        CanReply r = new CanReply(6);
        r.setElement(0, 182);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, this.getNodeParamManager().getParameter(1) & 0xFF);
        r.setElement(4, this.getNodeParamManager().getParameter(3) & 0xFF);
        r.setElement(5, this.getNodeParamManager().getParameter(8) & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendPARAN(int index) {
        try {
            CanReply r = new CanReply(5);
            r.setElement(0, 155);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, this.getNodeParamManager().getParameter(index) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.sendCMDERR(9);
        }
    }

    protected void sendNVANS(int index) {
        try {
            CanReply r = new CanReply(5);
            r.setElement(0, 151);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            r.setElement(3, index & 0xFF);
            r.setElement(4, this.getNodeNvManager().getNV(index) & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.sendCMDERR(10);
        }
    }

    protected void setDummyNV(int index, int newval) {
        if (this.getnvWriteInLearnOnly() && !this.getNodeInLearnMode()) {
            this.sendCMDERR(2);
            return;
        }
        if (newval < 0 || newval > 255) {
            this.sendCMDERR(12);
            return;
        }
        if (index == 0) {
            this.sendCMDERR(10);
            return;
        }
        try {
            this.getNodeNvManager().setNV(index, newval);
            if (this.getsendsWRACKonNVSET()) {
                this.sendWRACK();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.sendCMDERR(10);
        }
    }

    protected void sendCMDERR(int errorId) {
        CanReply r = new CanReply(4);
        r.setElement(0, 111);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        r.setElement(3, errorId & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    protected void sendWRACK() {
        CanReply r = new CanReply(3);
        r.setElement(0, 89);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }

    public void flimButton() {
        if (this.getNodeParamManager().getParameter(3) > 0) {
            this.setNodeInSetupMode(true);
            CanReply r = new CanReply(3);
            r.setElement(0, 80);
            r.setElement(1, this.getNodeNumber() >> 8);
            r.setElement(2, this.getNodeNumber() & 0xFF);
            this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
        }
    }

    public void setPane(NdPane pane) {
        this._pane = pane;
    }

    protected void setDNN(int nn) {
        this.setNodeNumber(nn);
        this.setNodeInFLiMMode(true);
        this.setNodeInSetupMode(false);
        if (this._pane != null) {
            this._pane.updateNodeGui();
        }
        CanReply r = new CanReply(3);
        r.setElement(0, 82);
        r.setElement(1, this.getNodeNumber() >> 8);
        r.setElement(2, this.getNodeNumber() & 0xFF);
        this.send.sendWithDelay(r, this.canListener.getSendIn(), this.canListener.getSendOut(), this.canListener.getDelay());
    }
}

