/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusOpCodes;
import jmri.jmrix.can.cbus.simulator.Bundle;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventResponder
extends CbusSimCanListener {
    private int _node;
    private int _mode;
    public ArrayList<String> evModes;
    public ArrayList<String> evModesTip;
    private static final Logger log = LoggerFactory.getLogger(CbusEventResponder.class);

    public CbusEventResponder(CanSystemConnectionMemo memod) {
        super(memod, null);
        this.init();
    }

    private void init() {
        this._mode = 1;
        this._node = -1;
        this.setDelay(50);
        this.evModes = new ArrayList();
        this.evModesTip = new ArrayList();
        this.evModes.add(Bundle.getMessage("HighlightDisabled"));
        this.evModesTip.add(null);
        this.evModes.add(Bundle.getMessage("onOffRand"));
        this.evModesTip.add(null);
        this.evModes.add(Bundle.getMessage("odOnEvOff"));
        this.evModesTip.add(null);
        this.evModes.add(Bundle.getMessage("CbusEventOn"));
        this.evModesTip.add(null);
        this.evModes.add(Bundle.getMessage("CbusEventOff"));
        this.evModesTip.add(null);
        log.info("Simulated Event Responses: {}", (Object)this.evModes.get(this._mode));
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public int getMode() {
        return this._mode;
    }

    public void setNode(int node) {
        this._node = node;
    }

    public int getNode() {
        return this._node;
    }

    @Override
    protected void startProcessFrame(AbstractMessage m) {
        if (!CbusOpCodes.isEventRequest(m.getElement(0)) || this._mode == 0 || this._node != -1 && this._node != CbusMessage.getNodeNumber(m)) {
            return;
        }
        int newopc = 148;
        if (CbusMessage.getOpcode(m) == 154) {
            newopc = this.getOnOrOffFromMode(m) ? 157 : 158;
        } else if (this.getOnOrOffFromMode(m)) {
            newopc = 147;
        }
        this.sendResponse(newopc, m);
    }

    private void sendResponse(int newopc, AbstractMessage m) {
        CanReply r = new CanReply(5);
        r.setNumDataElements(5);
        r.setElement(0, newopc);
        r.setElement(1, m.getElement(1));
        r.setElement(2, m.getElement(2));
        r.setElement(3, m.getElement(3));
        r.setElement(4, m.getElement(4));
        this.send.sendWithDelay(r, this.getSendIn(), this.getSendOut(), this.getDelay());
    }

    private boolean getOnOrOffFromMode(AbstractMessage m) {
        boolean sendOn = false;
        switch (this._mode) {
            case 1: {
                sendOn = ThreadLocalRandom.current().nextBoolean();
                break;
            }
            case 2: {
                sendOn = m.getElement(4) % 2 != 0;
                break;
            }
            case 3: {
                sendOn = true;
                break;
            }
            case 4: {
                sendOn = false;
                break;
            }
        }
        return sendOn;
    }
}

