/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.spi.JmriServiceProviderInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CbusSimulatedModuleProvider
implements JmriServiceProviderInterface {
    private static volatile Map<String, CbusSimulatedModuleProvider> instanceMap = null;
    private static final Logger log = LoggerFactory.getLogger(CbusSimulatedModuleProvider.class);

    public abstract int getManufacturerId();

    public abstract int getModuleId();

    public abstract void configureDummyNode(@Nonnull CbusNode var1);

    @Nonnull
    public String getModuleType() {
        StringBuilder s = new StringBuilder();
        s.append(CbusNodeConstants.getManu(this.getManufacturerId()));
        s.append(" ");
        s.append(CbusNodeConstants.getModuleType(this.getManufacturerId(), this.getModuleId()));
        return s.toString();
    }

    @Nonnull
    public String getToolTipText() {
        return "Simulation of " + CbusNodeConstants.getModuleTypeExtra(this.getManufacturerId(), this.getModuleId());
    }

    @Nonnull
    public CbusDummyNode getNewDummyNode(CanSystemConnectionMemo memo, int nodeNumber) {
        CbusDummyNode nd = this.createNewDummyNode(memo, nodeNumber);
        this.configureDummyNode(nd);
        CbusNodeConstants.setTraits(nd);
        log.info("Simulated CBUS Module: {}", (Object)this.getModuleType());
        return nd;
    }

    protected CbusDummyNode createNewDummyNode(CanSystemConnectionMemo memo, int nodeNumber) {
        return new CbusDummyNode(memo, nodeNumber);
    }

    public boolean matchesManuAndModuleId(@CheckForNull CbusDummyNode nd) {
        if (nd == null) {
            return false;
        }
        return nd.getNodeParamManager().getParameter(1) == this.getManufacturerId() && nd.getNodeParamManager().getParameter(3) == this.getModuleId();
    }

    @CheckForNull
    public static final CbusSimulatedModuleProvider getProviderByName(String name) {
        CbusSimulatedModuleProvider.loadInstances();
        return instanceMap.get(name);
    }

    @Nonnull
    public static final Collection<CbusSimulatedModuleProvider> getInstancesCollection() {
        CbusSimulatedModuleProvider.loadInstances();
        return Collections.unmodifiableCollection(instanceMap.values());
    }

    private static void loadInstances() {
        if (instanceMap != null) {
            return;
        }
        instanceMap = new TreeMap<String, CbusSimulatedModuleProvider>();
        ServiceLoader.load(CbusSimulatedModuleProvider.class).forEach(module -> {
            if (!instanceMap.containsKey(module.getModuleType())) {
                instanceMap.put(module.getModuleType(), (CbusSimulatedModuleProvider)module);
            }
        });
    }
}

